package networkdomain

import (
	"github.com/google/uuid"
)

// NetworkDomain provides an interface for network domain implementations
// like principal network domain or logical network domain.
type NetworkDomain interface {
	GetName() string
	GetDescription() string
	ID() uuid.UUID
}

// LoadedPnd represents a PND that was loaded.
type LoadedPnd struct {
	ID          string `json:"id" bson:"_id,omitempty"`
	Name        string `json:"name,omitempty"`
	Description string `json:"description,omitempty"`
}
