package change

import (
	"time"

	mnepb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/networkelement"

	"github.com/google/uuid"
	"github.com/openconfig/gnmi/proto/gnmi"
)

// Change is an intended change to an MNE. It is unique and immutable.
// It has a cuid, a timestamp, and holds both the previous and the new
// state. It keeps track if the state is committed and confirmed. A callback
// exists to acess the proper transport for the changed MNE.
type Change interface {
	ID() uuid.UUID
	Age() time.Duration
	State() mnepb.ChangeState
	Commit() error
	Confirm() error
	PreviousState() []byte
	IntendedState() []byte
	Diff() *gnmi.Notification
	AssociatedDeviceID() uuid.UUID
}

// Payload contains two ygot.GoStructs, the first represents the original state
// before the change was applied and the second repesents the modified state.
type Payload struct {
	Original []byte
	Modified []byte
	Diff     *gnmi.Notification
}
