package controller

import (
	"os"
	"testing"

	"code.fbi.h-da.de/danet/gosdn/controller/config"

	"github.com/google/uuid"
	log "github.com/sirupsen/logrus"
)

const apiEndpoint = "http://localhost:8080"

// UUIDs for test cases.
var mdid uuid.UUID
var defaultPndID uuid.UUID
var cuid uuid.UUID

func TestMain(m *testing.M) {
	log.SetReportCaller(true)
	log.SetLevel(config.LogLevel)

	readTestUUIDs()
	os.Exit(m.Run())
}

func readTestUUIDs() {
	var err error
	mdid, err = uuid.Parse("688a264e-5f85-40f8-bd13-afc42fcd5c7a")
	if err != nil {
		log.Fatal(err)
	}
	defaultPndID, err = uuid.Parse("b4016412-eec5-45a1-aa29-f59915357bad")
	if err != nil {
		log.Fatal(err)
	}
	cuid, err = uuid.Parse("3e8219b0-e926-400d-8660-217f2a25a7c6")
	if err != nil {
		log.Fatal(err)
	}
}
