package eventservice

import (
	"fmt"

	"code.fbi.h-da.de/danet/gosdn/controller/event"
	interfaces "code.fbi.h-da.de/danet/gosdn/controller/interfaces/event"
)

func amqpURIBuilder(prefix, user, pass, host, port string) string {
	return fmt.Sprintf("%s%s:%s@%s:%s/", prefix, user, pass, host, port)
}

// MockEventService is used to setup a connection to a broker and publish events to topics.
type MockEventService struct {
	Queue map[string][]event.Event
}

// NewMockEventService creates a new connection to the broker and opens a channel for later usage.
func NewMockEventService() interfaces.Service {
	return &MockEventService{
		Queue: make(map[string][]event.Event),
	}
}

// PublishEvent declares a queue and publishes events.
func (e *MockEventService) PublishEvent(topic string, event event.Event) error {
	e.Queue[topic] = append(e.Queue[topic], event)

	return nil
}

// CloseConnection closes an exisiting connection.
func (e *MockEventService) CloseConnection() {
}

// RetryPublish declares a queue and publishes events.
func (e *MockEventService) RetryPublish(topic string, event event.Event) error {
	e.Queue[topic] = append(e.Queue[topic], event)

	return nil
}

// Reconnect reconnects to the RabbitMQ server.
func (e *MockEventService) Reconnect() {
	// do nothing
}
