package event

import "github.com/google/uuid"

// Event is a event that can be published via the event service as payload.
type Event struct {
	ID                uuid.UUID         `json:"id,omitempty"`
	EntityID          uuid.UUID         `json:"entity_id,omitempty"`
	Type              string            `json:"type,omitempty"`
	PathsAndValuesMap map[string]string `json:"paths_and_values,omitempty"`
}

const (
	// TypeAdd is an add event.
	TypeAdd = "add"

	// TypeUpdate is an update event.
	TypeUpdate = "update"

	// TypeDelete is a delete event.
	TypeDelete = "delete"
)

// NewAddEvent creates a new add event.
func NewAddEvent(entityID uuid.UUID) Event {
	return Event{
		ID:       uuid.New(),
		EntityID: entityID,
		Type:     TypeAdd,
	}
}

// NewDeleteEvent creates a new delete event.
func NewDeleteEvent(entityID uuid.UUID) Event {
	return Event{
		ID:       uuid.New(),
		EntityID: entityID,
		Type:     TypeDelete,
	}
}

// NewUpdateEvent creates a new update event.
func NewUpdateEvent(entityID uuid.UUID) Event {
	return Event{
		ID:       uuid.New(),
		EntityID: entityID,
		Type:     TypeUpdate,
	}
}

// NewMneUpdateEvent creates a new update event for managed network elements.
func NewMneUpdateEvent(entityID uuid.UUID, pathsAndValues map[string]string) Event {
	return Event{
		ID:                uuid.New(),
		EntityID:          entityID,
		Type:              TypeUpdate,
		PathsAndValuesMap: pathsAndValues,
	}
}
