package controller

import (
	"context"
	"net/http"
	"reflect"
	"testing"
	"time"

	"code.fbi.h-da.de/danet/gosdn/controller/config"
	"github.com/spf13/viper"
)

func TestInit(t *testing.T) {
	viper.SetConfigFile("./configs/ci-testing-gosdn.toml")

	viper.Set("basePNDUUID", "3e58372e-b53d-41d8-a06e-4131810c8e70")
	viper.Set("plugin-registry", "localhost:55056")
	viper.Set("csbi-orchestrator", "localhost:55057")
}

// NOTE: There has been a change within to the grpc.Dial function in
// https://github.com/grpc/grpc-go/releases/tag/v1.52.0
func TestRun(t *testing.T) {
	TestInit(t)
	err := config.InitializeConfig()
	if err != nil {
		t.Error(err)
		return
	}

	if err := viper.ReadInConfig(); err != nil {
		t.Errorf("Run() could not find config file. File used = %v", viper.ConfigFileUsed())
	}

	type args struct {
		request string
	}
	tests := []struct {
		name string
		args args
		want interface{}
	}{
		{
			name: "liveliness indicator",
			args: args{request: apiEndpoint + "/livez"},
			want: http.StatusOK,
		},
		{
			name: "readyness indicator",
			args: args{request: apiEndpoint + "/readyz"},
			want: http.StatusOK,
		},
	}

	ctx, cancel := context.WithCancel(context.Background())

	go func() {
		if err := Run(ctx); err != nil {
			t.Errorf("Run() error = %v", err)
		}
	}()
	time.Sleep(time.Second)
	t.Run("Controller Start HTTP API", func(t *testing.T) {
		got, err := http.Get(tests[0].args.request)
		if err != nil {
			t.Error(err)
			return
		}
		if !reflect.DeepEqual(got.StatusCode, tests[0].want) {
			t.Errorf("livez got: %v, want %v", got.StatusCode, tests[0].want)
		}
		got, err = http.Get(tests[1].args.request)
		if err != nil {
			t.Error(err)
			return
		}
		if !reflect.DeepEqual(got.StatusCode, tests[1].want) {
			t.Errorf("readyz got: %v, want %v", got.StatusCode, tests[1].want)
		}
	})

	cancel()
}
