ARG GOLANG_VERSION=1.20.5
ARG BUILDARGS
ARG $GITLAB_PROXY

FROM ${GITLAB_PROXY}golang:$GOLANG_VERSION-buster as builder
WORKDIR /gosdn/
COPY . .
RUN --mount=type=cache,target=/root/go/pkg/mod \
    --mount=type=cache,target=/root/.cache/go-build \
    make build-gosdn

FROM ${GITLAB_PROXY}golang:$GOLANG_VERSION-buster
WORKDIR /app/
COPY --from=builder /gosdn/controller/configs/development-gosdn.toml.example ./configs/development-gosdn.toml
COPY --from=builder /gosdn/controller/configs/containerlab-gosdn.toml.example ./configs/containerlab-gosdn.toml
COPY --from=builder /gosdn/controller/configs/gNMISubscriptions.txt.example ./configs/gNMISubscriptions.txt
COPY --from=builder /gosdn/artifacts/gosdn ./gosdn
ENTRYPOINT ["./gosdn"]
