package config

import (
	"os"
	"strings"
)

// Environment is used to determine the environment the controller is running in.
type Environment int64

const (
	// Development is used for local development.
	Development Environment = iota
	// Production is used for production deployments.
	Production
	// Testing is used for tests.
	Testing
)

func (e Environment) String() string {
	switch e {
	case Development:
		return "development"
	case Production:
		return "production"
	case Testing:
		return "testing"
	}

	return "development"
}

// DetermineConfigEnvironment returns the environment mode the controller should use.
func DetermineConfigEnvironment() Environment {
	env := os.Getenv("ENVIRONMENT")

	switch strings.ToLower(env) {
	case "development":
		return Development
	case "production":
		return Production
	case "testing":
		return Testing
	default:
		return Development
	}
}
