package cmd

import (
	"fmt"

	"code.fbi.h-da.de/danet/gosdn/controller/version"
	log "github.com/sirupsen/logrus"
	"github.com/spf13/cobra"
)

// version represents the version command.
var versionCmd = &cobra.Command{
	Use:   "version",
	Short: "returns information about the controllers version",
	Long: `Version allows the user to access version and build information
    about the current binary.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		log.SetFormatter(&log.TextFormatter{
			DisableQuote: true,
		})
		v, err := version.NewVersion()
		if err != nil {
			log.Error(err)
		}
		fmt.Println(v.String())
		return nil
	},
}

func init() {
	rootCmd.AddCommand(versionCmd)
}
