package app

import "github.com/google/uuid"

// MockAppService is used to setup a connection to a broker and publish events to topics.
type MockAppService struct {
	Store map[string]App
}

// NewMockAppService creates mock app service.
func NewMockAppService() ManagementService {
	return &MockAppService{
		Store: make(map[string]App),
	}
}

// Register checks if the app already exists and if not creates a new one.
func (a *MockAppService) Register(appName, token string) (*App, error) {
	app, ok := a.Store[appName]
	if !ok {
		app := App{
			ID:                     uuid.New(),
			Name:                   appName,
			EventSystemCredentials: "test",
		}
		a.Store[appName] = app

		return &app, nil
	}

	return &app, nil
}

// Deregister deregisters an app.
func (a *MockAppService) Deregister(appName string) error {
	delete(a.Store, appName)

	return nil
}
