package app

import "github.com/google/uuid"

// App represents a northbound app.
type App struct {
	ID                     uuid.UUID `bson:"_id,omitempty"`
	Name                   string    `bson:"name,omitempty"`
	EventSystemCredentials string    `bson:"event_system_credentials,omitempty"`
}

// GetID returns the uuid of an app.
func (a *App) GetID() uuid.UUID {
	return a.ID
}

// GetCredentials returns the credentials of an app.
func (a *App) GetCredentials() string {
	return a.EventSystemCredentials
}
