package api

import (
	"context"
	"errors"
	"time"

	ppb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/pnd"
	nbi "code.fbi.h-da.de/danet/gosdn/controller/northbound/client"
)

// AddPnd takes a name, description and SBI UUID to create a new
// PrincipalNetworkDomain on the controller.
func AddPnd(ctx context.Context, addr, name, description string) (*ppb.CreatePndListResponse, error) {
	pndClient, err := nbi.PndClient(addr, dialOptions...)
	if err != nil {
		return nil, err
	}

	req := &ppb.CreatePndListRequest{
		Timestamp: time.Now().UnixNano(),
		Pnd: []*ppb.PndCreateProperties{
			{
				Name:        name,
				Description: description,
			},
		},
	}

	return pndClient.CreatePndList(ctx, req)
}

// GetPnd requests one PrincipalNetworkDomain from the
// controller.
func GetPnd(ctx context.Context, addr string, args string) (*ppb.GetPndResponse, error) {
	pndClient, err := nbi.PndClient(addr, dialOptions...)
	if err != nil {
		return nil, err
	}
	if len(args) <= 0 {
		return nil, errors.New("not enough arguments")
	}

	req := &ppb.GetPndRequest{
		Timestamp: time.Now().UnixNano(),
		Pid:       args,
	}
	return pndClient.GetPnd(ctx, req)
}

// GetPnds requests all PrincipalNetworkDomains from the
// controller.
func GetPnds(ctx context.Context, addr string, args ...string) (*ppb.GetPndListResponse, error) {
	pndClient, err := nbi.PndClient(addr, dialOptions...)
	if err != nil {
		return nil, err
	}

	req := &ppb.GetPndListRequest{
		Timestamp: time.Now().UnixNano(),
	}
	return pndClient.GetPndList(ctx, req)
}

// DeletePnd requests a deletion of the provided PND.
func DeletePnd(ctx context.Context, addr string, pid string) (*ppb.DeletePndResponse, error) {
	pndClient, err := nbi.PndClient(addr, dialOptions...)
	if err != nil {
		return nil, err
	}

	req := &ppb.DeletePndRequest{
		Timestamp: time.Now().UnixNano(),
		Pid:       pid,
	}
	return pndClient.DeletePnd(ctx, req)
}
