package api

import (
	"context"
	"time"

	pib "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/plugin-internal"
	prb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/plugin-registry"
	nbi "code.fbi.h-da.de/danet/gosdn/controller/northbound/client"
)

// GetAvailablePlugins requests all available plugins that can be registered
// within the controller. The set of available plugins is based on the
// plugin-registry in use.
func GetAvailablePlugins(ctx context.Context, addr string) (*prb.GetResponse, error) {
	pluginRegistryClient, err := nbi.PluginClient(addr, dialOptions...)
	if err != nil {
		return nil, err
	}

	req := &pib.GetAvailablePluginsRequest{
		Timestamp: time.Now().UnixNano(),
	}

	return pluginRegistryClient.AvailablePlugins(ctx, req)
}
