package api

import (
	"context"
	"time"

	apb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/rbac"
	nbi "code.fbi.h-da.de/danet/gosdn/controller/northbound/client"
)

// Login logs a user in.
func Login(ctx context.Context, addr, username, pwd string) (*apb.LoginResponse, error) {
	authClient, err := nbi.AuthClient(addr, dialOptions...)
	if err != nil {
		return nil, err
	}

	r := &apb.LoginRequest{
		Timestamp: time.Now().UnixNano(),
		Username:  username,
		Pwd:       pwd,
	}
	return authClient.Login(ctx, r)
}

// Logout logs a user out.
func Logout(ctx context.Context, addr, username string) (*apb.LogoutResponse, error) {
	authClient, err := nbi.AuthClient(addr, dialOptions...)
	if err != nil {
		return nil, err
	}

	r := &apb.LogoutRequest{
		Timestamp: time.Now().UnixNano(),
		Username:  username,
	}
	return authClient.Logout(ctx, r)
}
