# goSDN [![coverage report](https://code.fbi.h-da.de/danet/gosdn/badges/master/coverage.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/master) [![pipeline status](https://code.fbi.h-da.de/danet/gosdn/badges/master/pipeline.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/master)


`goSDN` is a prototypical approach to build a model driven multi-vendor SDN controller.

# Table of Contents

- [Overview](#overview)
- [Concepts](#concepts)
- [Installing](#installing)
- [Getting Started](#getting-started)
  * [k8s](#k8s)
  * [Using the goSDN CLI](#using-the-cli)
  * [Example](#example)
- [Contributing](CONTRIBUTING.md)
- [License](LICENSE)
- [CI Status](#ci-status)

# Overview

`goSDN` is also an application that will allow you to manage your multi-vendor network using one unified controller.

`goSDN` provides:
* Model driven device representation
* Native multi vendor support
* Multi controller environments

# Concepts

The `goSDN` core - also called `nucleus` - is a lightweight library that manages principal network domains and provides southbound interface operations for managed network elements.

## Principal Networking Domain (PND)

The PND is the single source of truth within a network. Its state is held and maintained by the controller. Any configuration of an MNE has to be applied by the PND.

## Managed Network Element (MNE)

Any network element directly configured by `goSDN`

# Installing
You can install the latest release of `goSDN` locally using the `go get` command. Since the repository and some dependencies are not publicly available you have to modify your git config first:
```sh
> git config --global url."git@code.fbi.h-da.de:".insteadOf "https://code.fbi.h-da.de"
> go env -w GOPRIVATE=code.fbi.h-da.de/cocsn/*
> go get code.fbi.h-da.de/danet/gosdn/cmd/gosdn
```

To install the development version you need to clone the repo and use `go install` to build and install the binary:
```sh
# If you haven't cloned the repo yet
> git config --global url."git@code.fbi.h-da.de:".insteadOf "https://code.fbi.h-da.de"
> go env -w GOPRIVATE=code.fbi.h-da.de/cocsn/*
> cd $GOPATH/src
> git clone git@code.fbi.h-da.de:cocsn/gosdn.git

# checkout the develop branch (or any other branch)
> cd $GOPATH/src/code.fbi.h-da.de/danet/gosdn
> git checkout develop
> go install ./cmd/gosdn
```

Now you can start `goSDN` locally using the `gosdn` command or [use the CLI](#using-the-cli) to interact with a running `goSDN` instance.

# Getting Started
## k8s

We have an instance of `goSDN` for each the latest master and current develop branch running on the department's k8s cluster. These endpoints can be accessed using the `gosdn cli` command. If anything breaks please file an [issue](https://code.fbi.h-da.de/danet/gosdn/-/issues/new).

## Using the CLI

The CLI for goSDN is provided as the separate `gosdnc` application.
Please refer to the [README](https://code.fbi.h-da.de/danet/gosdnc/-/blob/develop/README.md) there.

# CI Status

| Master | Develop |
| ------ | ------ |
| [![coverage report](https://code.fbi.h-da.de/danet/gosdn/badges/master/coverage.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/master) | [![coverage report](https://code.fbi.h-da.de/danet/gosdn/badges/develop/coverage.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/develop) |
| [![pipeline status](https://code.fbi.h-da.de/danet/gosdn/badges/master/pipeline.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/master) | [![pipeline status](https://code.fbi.h-da.de/danet/gosdn/badges/develop/pipeline.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/develop) |
