# goSDN Architecture

This document describes the the high-level architecture of the goSDN project. All contributors should familiarize themselves with it. To avoid too much divergence from the changing code this document does focus on high-level concepts instead of implementation details.

## Bird's Eye View

[<img src="documentation/architecture.png"  style="height:50%; width:50%" > ](documentation/architecture.png)

On the highest level goSDn provides a gRPC northbound-interface and two types of southbound-interfaces: RESTCONF and gRPC-based. The northbound interface allows the interaction with a running goSDN daemon and may allow the stacking of multiple controllers in the future. The southbound interface (SBI) capabilities are split in `nucleus` models and plugins. The supported `nucleus` models are OpenConfig yang [openconfig-yang](https://github.com/openconfig/yang)  and TAPI. Third party models and more SBI-transports can be attached using the go plugin architecture.

The internal data representation uses [ygot](https://github.com/openconfig/ygot) generated go-structs.
It is important to note that these go-structs are generated from yang models and thus are not generic data structures. This means that the `nucleus` code is organized in silos, i.e., one particular southbound-interface is visible in the `nucleus`, as the internal data representation depend on the used yang modes in the southbound-interface.

## Code Map

This section briefly describes important directories and data structures. It also introduces important API calls to relevant libraries.


It also mentions **architecture invariants** and **API boundaries**
### `api`

API specification for gRPC and protobuf definitions.

**Architecture invariant:** To import gRPC related protobuf definitions use `pb` as an import prefix. For gNMI related protobuf definitions use `gpb`

### `forks`

Forks of `google/gnxi/gnmi` and `arista/goarista/gnmi` for gNMI server and client respectively. Subject of change once we converge to own clients and servers.

### `nucleus/principalNetworkDomain`

`nucleus` is the core package of goSDN. The main data structure is the `principalNetworkDomain` (PND). It reflects one administrative entity, i.e., as set of connected network network elements,  and is the source of truth for network state and configuration. A PND is SBI agnostic and supports multiple SBI implementations simultaneously.

**API boundary:** The PND' is the only way to interact with an `managedNetworkElement`

### `nucleus/network element`

This is the representation of an `managedNetworkElement` (MNE). An `managedNetworkElement` is the network network element that is directly managed by goSDN. It holds a reference to the network element's `transport` and `southboundInterface` implementation. It contains a fakeroot network element based on its attached SBI.

**Architecture invariant:** The network element is does not provide any functionality to upper API layers.

### `nucleus/southbound`

Implementation of SBI specifics. Provides SBI models to other callers and SBI specific function deviations.

**Architecture invariant:** Only SBIs defined by a YANG model will be supported by goSDN.

### `nucleus/transport` `nucleus/gnmi_transport` `nucleus/restconf_transport`

Transport between goSDN and MNEs. Current core implementations are gNMI and RESTCONF. Additionally to implementing the transports the packages also provide a mapping from general purpose goSDN API calls to diverging SBI API calls.

For example `gNMI::Subscribe` and `RESTCONF::Push` are mapped to `gosdn::Subscribe`.

The `gnmi_transport` implementation uses `ytypes.SetNode` to write to a network element struct.
