package completer

import (
	"sort"

	"github.com/c-bata/go-prompt"
)

// SortSuggestionByText sorts the suggestion slice, otherwise the order of the slice will be
// random.
func SortSuggestionByText(suggestions []prompt.Suggest) []prompt.Suggest {
	// sort the suggestion slice, otherwise the order of the slice will be
	// random.
	sort.Slice(suggestions, func(i, j int) bool {
		return suggestions[i].Text < suggestions[j].Text
	})

	return suggestions
}
