/*
Copyright © 2021 da/net Research Group <danet@h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	apb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/rbac"
	"code.fbi.h-da.de/danet/gosdn/controller/api"
	log "github.com/sirupsen/logrus"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// loginCmd represents the login command.
var userCreateCmd = &cobra.Command{
	Use:   "userCreate",
	Short: "Creates a user with provided data",
	Long: `Creates a user with provided data.
    User name and password hashed with (add hash method here!) required,
    role is optional but needed to operate on PNDs.`,

	RunE: func(cmd *cobra.Command, args []string) error {

		roles := map[string]string{}
		// only active pnd for now, add option for additional param later
		roles[viper.GetString("CLI_PND")] = nbUserRole

		// only one for now, add option to add more users at once later
		users := []*apb.User{
			{
				Name:     nbUserName,
				Password: nbUserPwd,
				Roles:    roles,
			},
		}

		resp, err := api.CreateUsers(createContextWithAuthorization(), viper.GetString("controllerAPIEndpoint"), users)
		if err != nil {
			return err
		}
		log.Infof("Users created: %v", resp.Status)

		return nil
	},
	PostRun: func(cmd *cobra.Command, args []string) {
		// Necessary for prompt mode. The flag variables have to be resetted,
		// since in prompt mode the program keeps running.
		nbUserName, nbUserPwd, nbUserRole = "", "", ""
	},
}

var nbUserRole string

func init() {
	rootCmd.AddCommand(userCreateCmd)

	userCreateCmd.Flags().StringVar(&nbUserName, "u", "", "username for login")
	userCreateCmd.Flags().StringVar(&nbUserPwd, "p", "", "pwd for login")
	userCreateCmd.Flags().StringVar(&nbUserRole, "r", "", "role for user")
}
