/*
Copyright © 2021 da/net research group <danet.fbi.h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	"code.fbi.h-da.de/danet/gosdn/cli/adapter"
	"code.fbi.h-da.de/danet/gosdn/controller/api"
	"github.com/pterm/pterm"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// pndUseCmd represents the pnd command.
var pndUseCmd = &cobra.Command{
	Use:   "use [uuid]",
	Args:  cobra.ExactArgs(1),
	Short: "change currently used PND for the CLI",
	Long:  `Change currently used PND for the CLI.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		var newPND = args[0]

		newPndAdapter, err := adapter.NewPndAdapter(newPND, viper.GetString("controllerAPIEndpoint"))
		if err != nil {
			pterm.Error.Println(err)
			return err
		}

		_, err = api.GetPnd(createContextWithAuthorization(), viper.GetString("controllerAPIEndpoint"), newPND)
		if err != nil {
			pterm.Error.Println(err)
			return err
		}

		viper.Set("CLI_PND", newPND)

		err = viper.WriteConfig()
		if err != nil {
			pterm.Error.Println(err)
			return err
		}
		pndAdapter = newPndAdapter
		pterm.Info.Printf("PND with ID: %s has been set for usage.\n", pndAdapter.ID().String())
		return nil
	},
}

func init() {
	pndCmd.AddCommand(pndUseCmd)
}
