/*
Copyright © 2021 da/net research group <danet.fbi.h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	"code.fbi.h-da.de/danet/gosdn/controller/api"
	"github.com/pterm/pterm"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// pndGetCmd represents the get command.
var pndGetCmd = &cobra.Command{
	Use:   "get",
	Args:  cobra.ExactArgs(1),
	Short: "Request a PND by uuid.",
	Long:  `Request a PND specified by uuid. The PND's UUID, Name and Description are returned.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		spinner, _ := pterm.DefaultSpinner.Start("Fetching requested PNDs from controller.")
		resp, err := api.GetPnd(createContextWithAuthorization(), viper.GetString("controllerApiEndpoint"), args[0])
		if err != nil {
			spinner.Fail(err)
			return err
		}

		pnd := resp.Pnd
		panel1 := pterm.DefaultBox.WithTitle("UUID:").Sprint(pnd.Id)
		panel2 := pterm.DefaultBox.WithTitle("Name:").Sprint(pnd.Name)
		panel3 := pterm.DefaultBox.WithTitle("Description:").Sprint(pnd.Description)

		panels, _ := pterm.DefaultPanel.WithPanels(pterm.Panels{
			{{Data: panel1}},
			{{Data: panel2}},
			{{Data: panel3}},
		}).Srender()

		spinner.Success()
		pterm.DefaultBox.WithRightPadding(0).WithBottomPadding(0).Println(panels)
		return nil
	},
}

func init() {
	pndCmd.AddCommand(pndGetCmd)
}
