/*
Copyright © 2021 da/net research group <danet.fbi.h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	ppb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/pnd"
	"code.fbi.h-da.de/danet/gosdn/controller/api"
	"github.com/pterm/pterm"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// pndCreateCmd represents the create command.
var pndCreateCmd = &cobra.Command{
	Use:   "create [description]",
	Args:  cobra.ExactArgs(0),
	Short: "creates a new principal network domain to the controller",
	Long: `A principal network domain is a main networking entity. This can be a
campus building or site.

A description must be passed as positional argument.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		spinner, _ := pterm.DefaultSpinner.Start("Creating new PND")
		resp, err := api.AddPnd(createContextWithAuthorization(), viper.GetString("controllerApiEndpoint"), pndName, pndDescription)
		if err != nil {
			spinner.Fail(err)
			return err
		}

		if resp.Status == ppb.Status_STATUS_OK {
			spinner.Success("PND has been created with name: ", pndName)
		} else {
			spinner.Fail("Failed creating the PND with name: ", pndName)
		}

		return nil
	},
	PostRun: func(cmd *cobra.Command, args []string) {
		// Necessary for prompt mode. The flag variables have to be resetted,
		// since in prompt mode the program keeps running.
		pndName, pndDescription = "", ""
	},
}

var pndName string
var pndDescription string

func init() {
	pndCmd.AddCommand(pndCreateCmd)

	pndCreateCmd.Flags().StringVar(&pndName, "name", "", "the name of the pnd")
	pndCreateCmd.Flags().StringVar(&pndDescription, "description", "", "description of the pnd")
}
