/*
Copyright © 2021 da/net research group <danet.fbi.h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	"errors"
	"io"

	mnepb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/networkelement"
	"github.com/google/uuid"
	"github.com/pterm/pterm"
	log "github.com/sirupsen/logrus"
	"github.com/spf13/cobra"
)

// deviceGetCmd represents the get command.
var deviceSubscribeCmd = &cobra.Command{
	Use:   "subscribe [uuid] [path]",
	Args:  cobra.ExactArgs(2),
	Short: "Subscribes to paths of a provided device with fixed subscribe options",
	Long: `Requests a subscription on paths from a specified orchestrated network device on the controller.
The device UUID and requested paths must be specified as a positional arguments.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		did, err := uuid.Parse(args[0])
		if err != nil {
			pterm.Error.Println(err)
			return err
		}

		subClient, err := pndAdapter.SubscribeMNEPath(
			createContextWithAuthorization(),
			did,
			&mnepb.SubscriptionList{
				Subscription: []*mnepb.Subscription{
					{
						Path:           args[1],
						StreamMode:     mnepb.StreamMode_STREAM_MODE_SAMPLE,
						SampleInterval: 1000000000,
					},
				},
				Mode: mnepb.SubscriptionMode_SUBSCRIPTION_MODE_STREAM,
			},
		)
		if err != nil {
			pterm.Error.Println(err)
			return err
		}

		for i := 0; i < 5; i++ {
			subscribeResponse, err := subClient.Recv()
			if err != nil {
				if err != nil {

					if errors.Is(err, io.EOF) {
						break
					}
					log.Error(err)

					closeErr := subClient.CloseSend()
					if closeErr != nil {
						log.Error(err)
					}
				}
			}

			pterm.Println(subscribeResponse.String())
		}

		return nil
	},
}

func init() {
	networkElementCmd.AddCommand(deviceSubscribeCmd)
}
