/*
Copyright © 2021 da/net Research Group <danet@h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	"github.com/pterm/pterm"
	"github.com/spf13/cobra"
)

// networkElementShowCmd represents the show command.
var networkElementShowCmd = &cobra.Command{
	Use:   "show",
	Args:  cobra.ExactArgs(1),
	Short: "gets single network element information from the controller",
	Long: `Gets single orchestrated network network element information from the controller.
Network element UUID or name must be specified as a positional argument.
The network element information returned is the information as currently stored in the controller.
The actual network element is not queried directly.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		resp, err := pndAdapter.GetNetworkElement(createContextWithAuthorization(), args[0])
		if err != nil {
			pterm.Error.Println(err)
			return err
		}

		mne := resp.GetMne()

		panel1 := pterm.DefaultBox.WithTitle("UUID:").Sprint(mne.Id)
		panel2 := pterm.DefaultBox.WithTitle("Name:").Sprint(mne.Name)

		panels, _ := pterm.DefaultPanel.WithPanels(pterm.Panels{
			{{Data: panel1}},
			{{Data: panel2}},
		}).Srender()

		pterm.DefaultBox.WithRightPadding(0).WithBottomPadding(0).Println(panels)

		return nil
	},
}

func init() {
	networkElementCmd.AddCommand(networkElementShowCmd)
}
