/*
Copyright © 2021 da/net research group <danet.fbi.h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	mnepb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/networkelement"
	"github.com/google/uuid"
	"github.com/openconfig/gnmi/proto/gnmi"
	"github.com/openconfig/ygot/ygot"
	"github.com/pterm/pterm"
	"github.com/spf13/cobra"
)

// networkElementDeleteCmd represents the delete command.
var networkElementDeleteCmd = &cobra.Command{
	Use:   "delete [uuid] [path]",
	Args:  cobra.ExactArgs(2),
	Short: "delete a path on a network element",
	Long: `Delete a path for a given orchestrated network network element.
The network element UUID and request path must be specified as a positional arguments.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		spinner, _ := pterm.DefaultSpinner.Start("Create a path deletion request.")
		mneid, err := uuid.Parse(args[0])
		if err != nil {
			spinner.Fail(err)
			return err
		}

		path, err := ygot.StringToStructuredPath(args[1])
		if err != nil {
			spinner.Fail(err)
			return err
		}

		resp, err := pndAdapter.ChangeMNE(
			createContextWithAuthorization(),
			mneid,
			mnepb.ApiOperation_API_OPERATION_DELETE,
			path,
			&gnmi.TypedValue{},
		)
		if err != nil {
			spinner.Fail(err)
			return err
		}

		for _, r := range resp.Responses {
			if r.Status == mnepb.Status_STATUS_OK {
				spinner.Success("A change for path deletion for network element: ", mneid.String(), "has been created -> Change ID: ", r.GetId())
			} else {
				spinner.Fail("An error occurred while creating a path deletion request for network element with ID: ", r.GetId(), r.GetStatus())
			}
		}
		return nil
	},
}

func init() {
	networkElementCmd.AddCommand(networkElementDeleteCmd)
}
