/*
Copyright © 2021 da/net research group <danet.fbi.h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	"code.fbi.h-da.de/danet/gosdn/controller/api"
	log "github.com/sirupsen/logrus"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

var listCmd = &cobra.Command{
	Use:     "list",
	Aliases: []string{"ls"},
	Short:   "List all PNDs, SBIs and MNEs on the controller",
	Long:    `List all PNDs, SBIs and MNEs on the controller.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		addr := viper.GetString("controllerApiEndpoint")
		resp, err := api.GetIds(createContextWithAuthorization(), addr)
		if err != nil {
			return err
		}
		for i, pnd := range resp {
			mneResp, err := api.GetFlattenedNetworkElements(createContextWithAuthorization(), addr, pnd.GetId())
			if err != nil {
				return err
			}
			log.Infof("PND %v: name: %v, uuid: %v", i+1, pnd.Name, pnd.Id)
			for k, mne := range mneResp.GetMne() {
				log.Infof("    MNE %v: name: %v, uuid: %v", k+1, mne.Name, mne.Id)
				log.Infof("    Plugin %v: uuid: %v", k+1, mne.GetPid())
			}
		}
		return nil
	},
}

func init() {
	rootCmd.AddCommand(listCmd)
}
