/*
Copyright © 2021 da/net research group <danet.fbi.h-da.de>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
*/

package cmd

import (
	"github.com/pterm/pterm"
	"github.com/spf13/cobra"
)

// changeListCmd represents the list command.
var changeListCmd = &cobra.Command{
	Use:     "list",
	Aliases: []string{"ls"},
	Short:   "list all changes",
	Long:    `Lists all configuration changes with their UUIDs.`,

	RunE: func(cmd *cobra.Command, args []string) error {
		spinner, _ := pterm.DefaultSpinner.Start("Process change list request")
		committed, err := pndAdapter.CommittedChanges(createContextWithAuthorization())
		if err != nil {
			spinner.Fail(err)
			return err
		}
		pending, err := pndAdapter.PendingChanges(createContextWithAuthorization())
		if err != nil {
			spinner.Fail(err)
			return err
		}

		// TODO: maybe we want to return more information about changes? E.g.,
		// the diff of the change (probably only for a single get of a change).
		// This would require us to change pndAdapter methods.
		data := pterm.TableData{[]string{"UUID", "Status"}}
		for _, ch := range pending {
			data = append(data, []string{ch.String(), "pending"})
		}
		for _, ch := range committed {
			data = append(data, []string{ch.String(), "committed"})
		}

		spinner.Success()
		err = pterm.DefaultTable.WithHasHeader().WithData(data).Render()
		if err != nil {
			return err
		}

		return nil
	},
}

func init() {
	changeCmd.AddCommand(changeListCmd)
}
