package adapter

import (
	"context"
	"reflect"
	"testing"

	mnepb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/networkelement"
	tpb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/transport"
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/change"
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/networkdomain"
	"github.com/google/uuid"
	"github.com/openconfig/gnmi/proto/gnmi"
)

func TestNewAdapter(t *testing.T) {
	type args struct {
		id       string
		endpoint string
	}
	tests := []struct {
		name    string
		args    args
		want    networkdomain.NetworkDomain
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := NewPndAdapter(tt.args.id, tt.args.endpoint)
			if (err != nil) != tt.wantErr {
				t.Errorf("NewAdapter() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("NewAdapter() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestPndAdapter_RemoveSbi(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		in0 uuid.UUID
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if err := p.RemoveSbi(tt.args.in0); (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.RemoveSbi() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestPndAdapter_AddNetworkElement(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		name string
		opts *tpb.TransportOption
		sid  uuid.UUID
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if _, err := p.AddNetworkElement(context.TODO(), tt.args.name, tt.args.opts, tt.args.sid); (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.AddNetworkElement() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestPndAdapter_GetNetworkElement(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		identifier string
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		want    *mnepb.ManagedNetworkElement
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			got, err := p.GetNetworkElement(context.TODO(), tt.args.identifier)
			if (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.GetNetworkElement() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("PndAdapter.GetNetworkElement() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestPndAdapter_RemoveNetworkElement(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		mneid uuid.UUID
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if _, err := p.RemoveNetworkElement(context.TODO(), tt.args.mneid); (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.RemoveNetworkElement() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestPndAdapter_ChangeMNE(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		uuid      uuid.UUID
		operation mnepb.ApiOperation
		path      *gnmi.Path
		value     *gnmi.TypedValue
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			_, err := p.ChangeMNE(context.TODO(), tt.args.uuid, tt.args.operation, tt.args.path, tt.args.value)
			if (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.ChangeMNE() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestPndAdapter_Request(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		mneid uuid.UUID
		path  string
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			_, err := p.RequestPath(context.TODO(), tt.args.mneid, tt.args.path)
			if (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.Request() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestPndAdapter_RequestAll(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		in0 string
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if _, err := p.RequestAll(context.TODO(), tt.args.in0); (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.RequestAll() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestPndAdapter_ContainsNetworkElement(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		in0 uuid.UUID
	}
	tests := []struct {
		name   string
		fields fields
		args   args
		want   bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if got := p.ContainsNetworkElement(tt.args.in0); got != tt.want {
				t.Errorf("PndAdapter.ContainsNetworkElement() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestPndAdapter_ID(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	tests := []struct {
		name   string
		fields fields
		want   uuid.UUID
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if got := p.ID(); !reflect.DeepEqual(got, tt.want) {
				t.Errorf("PndAdapter.ID() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestPndAdapter_PendingChanges(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	tests := []struct {
		name   string
		fields fields
		want   []uuid.UUID
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if got, _ := p.PendingChanges(context.TODO()); !reflect.DeepEqual(got, tt.want) {
				t.Errorf("PndAdapter.PendingChanges() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestPndAdapter_CommittedChanges(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	tests := []struct {
		name   string
		fields fields
		want   []uuid.UUID
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if got, _ := p.CommittedChanges(context.TODO()); !reflect.DeepEqual(got, tt.want) {
				t.Errorf("PndAdapter.CommittedChanges() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestPndAdapter_GetChange(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		in []string
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		want    change.Change
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			got, err := p.GetChange(context.TODO(), tt.args.in...)
			if (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.GetChange() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("PndAdapter.GetChange() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestPndAdapter_Commit(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		cuid uuid.UUID
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if _, err := p.Commit(context.TODO(), tt.args.cuid); (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.Commit() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestPndAdapter_Confirm(t *testing.T) {
	type fields struct {
		id       uuid.UUID
		endpoint string
	}
	type args struct {
		cuid uuid.UUID
	}
	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			p := &PndAdapter{
				id:       tt.fields.id,
				endpoint: tt.fields.endpoint,
			}
			if _, err := p.Confirm(context.TODO(), tt.args.cuid); (err != nil) != tt.wantErr {
				t.Errorf("PndAdapter.Confirm() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func Test_filterChanges(t *testing.T) {
	type args struct {
		state mnepb.ChangeState
		resp  *mnepb.GetChangeListResponse
	}
	tests := []struct {
		name string
		args args
		want []uuid.UUID
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := filterChanges(tt.args.state, tt.args.resp); !reflect.DeepEqual(got, tt.want) {
				t.Errorf("filterChanges() = %v, want %v", got, tt.want)
			}
		})
	}
}
