# goSDN Command Line Interface

The goSDN CLI allows for management of the goSDN controller, and through it direct management of network elements.

***
## Command tree overview:

+ `gosdnc`
    + `login`
    + `logout`
    + `change`
        + `commit`
        + `confirm`
        + `list (alias ls)`
    + `networkElement (alias mne)`
        + `create`
        + `delete`
        + `get`
        + `list (alias ls)`
        + `remove (alias rm)`
        + `set`
        + `show`
    + `list (alias ls)`
    + `pnd`
        + `create`
        + `get`
        + `list (alias ls)`
        + `remove (alias rm)`
        + `use`
    + `userCreate`
    + `userDelete`
    + `userGet`
    + `userGetAll`
    + `userUpdate`
***
## Usage

To use the CLI, the `login` command must be called, with the `--controller` parameter specifying the target goSDN controller (\<IP:Port\>) and providing correct credentials.
The set controller address and recieved access token will be persisted for all following commands and can be changed by calling `login` again. If the `--controller` parameter is not specified, the default set in gosdnc.toml (`gosdn-develop.apps.ocp.fbi.h-da.de:55055`) will be used.

Command help is available via the --help flag for each command, or via the `gosdnc help` command.


### Examples

To initialize the CLI for a locally running goSDN controller:
`gosdnc login --controller 127.0.0.1:55055 --u name --p password`

#### Network element

To create a network element on the controller:
`gosdnc mne create -a 192.168.2.51:6030 --name='dev1'`

To get the network element UUIDs:
`gosdnc mne list` or `gosdnc mne ls`

To get a path directly from a network element:
`gosdnc mne get *appropriate UUID here* /system/config/hostname`

To update a path directly on a network element:
`gosdnc mne set *appropriate UUID here* /system/config/hostname test-hostname`

#### Changes

To commit/confirm the change from the update:
First, get the change UUID:
`gosdnc change list`

Second, commit the change:
`gosdnc change commit *appropriate UUID here*`

Third, confirm the committed change:
`gosdnc change confirm *appropriate UUID here*`

#### PND

To create an additional PND:
`gosdnc pnd create description-text --name=pnd-name`

To get the UUID information:
`gosdnc list`

To switch to the created PND:
`gosdnc pnd use *appropriate UUID here*`

#### User

To create an additional user:
`gosdnc userCreate --u name --p password --r role`

To delete an existing user:
`gosdnc userDelete --u name`

To fetch information about a user:
`gosdnc userGet --u name`

To fetch all available users:
`gosdnc userGetAll`

To update an existing user:
`gosdnc userUpdate --i <UUID of user> --u name --p password --r role`
