ARG GOLANG_VERSION=1.20.5
ARG BUILDARGS
ARG $GITLAB_PROXY=code.fbi.h-da.de:443/danet/dependency_proxy/containers

FROM ${GITLAB_PROXY}golang:$GOLANG_VERSION-buster AS builder

WORKDIR /gosdn

COPY go.* ./
RUN go mod download

COPY ./models/generated/openconfig ./models/generated/openconfig
COPY ./api ./api
COPY ./controller ./controller
COPY applications/venv-manager/ applications/venv-manager/

RUN CGO_ENABLED=0 GOOS=linux GOARCH=amd64 go build -ldflags="-w -s" -o venv-manager applications/venv-manager/main.go


FROM ubuntu:22.04
COPY --from=builder /gosdn/venv-manager /venv-manager

ENTRYPOINT ["/venv-manager"]
