package link

import (
	"code.fbi.h-da.de/danet/gosdn/applications/venv-manager/node"
	"code.fbi.h-da.de/danet/gosdn/applications/venv-manager/port"
)

// Link is a representation of a physical or virtual link between two nodes and their ports.
type Link struct {
	ID         string
	Name       string
	SourceNode *node.Node
	TargetNode *node.Node
	SourcePort *port.Port
	TargetPort *port.Port
}

// GetLinkAsSliceOfStrings returns the link as a slice of strings for yaml representation.
func (l *Link) GetLinkAsSliceOfStrings() [2]string {
	return [2]string{l.SourceNode.Name + ":" + l.SourcePort.Name, l.TargetNode.Name + ":" + l.TargetPort.Name}
}
