package containerlab

// Management represents the management part for containerlab.
type Management struct {
	Network    string `yaml:"network,omitempty"`
	Ipv4Subnet string `yaml:"ipv4-subnet,omitempty"`
	Ipv6Subnet string `yaml:"ipv6-subnet,omitempty"`
}

// Link represents a link for containerlab.
type Link struct {
	Endpoints [2]string `yaml:"endpoints"`
}

// Node represent a node for containerlab.
type Node struct {
	Kind     string `yaml:"kind"`
	Image    string `yaml:"image"`
	MgmtIpv4 string `yaml:"mgmt-ipv4"`
}

// Topology represent a topology for containerlab.
type Topology struct {
	Nodes map[string]Node `yaml:"nodes"`
	Links []Link          `yaml:"links"`
}

// YamlStruct represents the format for containerlab yaml.
type YamlStruct struct {
	Name     string     `yaml:"name"`
	Mgmt     Management `yaml:"mgmt"`
	Topology Topology   `yaml:"topology"`
}
