package main

import (
	"os"

	"code.fbi.h-da.de/danet/gosdn/application-framework/event"
	"code.fbi.h-da.de/danet/gosdn/application-framework/registration"
	"github.com/sirupsen/logrus"
)

func main() {
	queueCredentials, err := registration.Register("localhost:55055", "hostname-checker", "SecurePresharedToken")
	if err != nil {
		logrus.Errorf("failed to register application on control plane. %v", err)
		os.Exit(1)
	}

	eventService, err := event.NewEventService(
		queueCredentials,
		[]event.Topic{event.ManagedNetworkElement},
	)
	if err != nil {
		logrus.Errorf("failed to create event service. %v", err)
		os.Exit(1)
	}

	app := &Application{
		eventService: eventService,
		stopChannel:  make(chan os.Signal, 1),
	}

	app.Run()
}
