package main

import (
	"code.fbi.h-da.de/danet/gosdn/models/generated/arista"

	"github.com/google/uuid"
)

// Device is a device.
type Device struct {
	// UUID represents the Devices UUID
	UUID uuid.UUID

	// Name is the device's human readable Name
	Name string

	// Device embeds a ygot.GoStruct containing the device details
	Model arista.Device
}

// NewDevice creates a new device.
func NewDevice(id uuid.UUID, name string) *Device {
	return &Device{
		UUID:  id,
		Model: arista.Device{},
		Name:  name,
	}
}
