package main

import (
	"flag"
	"os"

	"code.fbi.h-da.de/danet/gosdn/application-framework/event"
	"code.fbi.h-da.de/danet/gosdn/application-framework/registration"
	"github.com/sirupsen/logrus"
)

var controllerAddress string
var indexPath string

func main() {
	flag.StringVar(&indexPath, "path", "webpage/index.html", "path to the webpage index.html file")
	flag.StringVar(&controllerAddress, "controller-address", "localhost:55055", "the address to the controller")

	flag.Parse()

	queueCredentials, err := registration.Register(controllerAddress, "basic-interface-monitoring", "SecurePresharedToken")
	if err != nil {
		logrus.Errorf("failed to register application on control plane. %v", err)
		os.Exit(1)
	}

	eventServiceNetworkElements, err := event.NewEventService(
		queueCredentials,
		[]event.Topic{event.ManagedNetworkElement},
	)
	if err != nil {
		logrus.Errorf("failed to create event service. %v", err)
		os.Exit(1)
	}

	app := &Application{
		eventServiceNetworkElements: eventServiceNetworkElements,
		stopChannel:                 make(chan os.Signal, 1),
	}

	app.Run(controllerAddress)
}
