package main

import (
	"os"

	"code.fbi.h-da.de/danet/gosdn/application-framework/event"
	"code.fbi.h-da.de/danet/gosdn/application-framework/registration"
	"github.com/sirupsen/logrus"
)

func main() {
	queueCredentials, err := registration.Register("localhost:55055", "arista-routing-engine", "SecurePresharedToken")
	if err != nil {
		logrus.Errorf("failed to register application on control plane. %v", err)
		os.Exit(1)
	}

	eventServiceLinks, err := event.NewEventService(
		queueCredentials,
		[]event.Topic{event.Link, event.Link},
	)
	if err != nil {
		logrus.Errorf("failed to create event service. %v", err)
		os.Exit(1)
	}

	eventServiceRoutes, err := event.NewEventService(
		queueCredentials,
		[]event.Topic{event.RoutingTable},
	)
	if err != nil {
		logrus.Errorf("failed to create event service. %v", err)
		os.Exit(1)
	}

	app := &Application{
		eventServiceLinks:  eventServiceLinks,
		eventServiceRoutes: eventServiceRoutes,
		stopChannel:        make(chan os.Signal, 1),
	}

	app.Run("localhost:55055")
}
