package models

import (
	"reflect"
	"testing"

	"code.fbi.h-da.de/danet/gosdn/models/generated/openconfig"
	"github.com/openconfig/ygot/ygot"
)

func Test_getYgotEmitJSONConfig(t *testing.T) {
	tests := []struct {
		name string
		want *ygot.EmitJSONConfig
	}{
		{
			name: "get valid json config",
			want: &ygot.EmitJSONConfig{
				Format:         ygot.RFC7951,
				Indent:         "",
				SkipValidation: true,
				RFC7951Config: &ygot.RFC7951JSONConfig{
					AppendModuleName: true,
				},
			},
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := getYgotEmitJSONConfig(); !reflect.DeepEqual(got, tt.want) {
				t.Errorf("getYgotEmitJSONConfig() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestGetModelAsString(t *testing.T) {
	type args struct {
		model ygot.GoStruct
	}
	tests := []struct {
		name    string
		args    args
		want    string
		wantErr bool
	}{
		{
			name: "Return empty model as string",
			args: args{
				model: &openconfig.Device{},
			},
			want:    "{}",
			wantErr: false,
		},
		// 		{
		// 			name: "Return model with hostname as string",
		// 			args: args{
		// 				model: &openconfig.Device{
		// 					System: &openconfig.OpenconfigSystem_System{
		// 						Config: &openconfig.OpenconfigSystem_System_Config{
		// 							Hostname: ygot.String("ernie"),
		// 						},
		// 					},
		// 				},
		// 			},
		// 			want: `{
		//     "openconfig-system:system": {
		//        "config": {
		//           "hostname": "ernie"
		//        }
		//     }
		// }`,
		// 			wantErr: false,
		// 		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := GetModelAsString(tt.args.model)
			if (err != nil) != tt.wantErr {
				t.Errorf("GetModelAsString() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if got != tt.want {
				t.Errorf("GetModelAsString() = %v, want %v", got, tt.want)
			}
		})
	}
}
