package event

import "strings"

// Type represents a event type.
type Type int64

const (
	// Add is an add event.
	Add Type = iota
	// Update is an update event.
	Update
	// Delete is a delete event.
	Delete
)

// String implements the stringer interface for types.
func (t Type) String() string {
	switch t {
	case Add:
		return "add"
	case Update:
		return "update"
	case Delete:
		return "delete"
	}

	return "unknown"
}

var (
	typeLookup = map[string]Type{
		"add":    Add,
		"update": Update,
		"delete": Delete,
	}
)

func parseTypeString(str string) Type {
	t, _ := typeLookup[strings.ToLower(str)]

	return t
}
