package event

// Topic represents a event topic.
type Topic int64

const (
	// User is the user topic.
	User Topic = iota
	// Role is the role topic.
	Role
	// ManagedNetworkElement is the network element topic.
	ManagedNetworkElement
	// Link is the link topic.
	Link
	// RoutingTable is the routingTable topic.
	RoutingTable
)

func (t Topic) String() string {
	switch t {
	case User:
		return "user"
	case Role:
		return "role"
	case ManagedNetworkElement:
		return "managedNetworkElement"
	case Link:
		return "link"
	case RoutingTable:
		return "routingTable"
	}

	return "unknown"
}
