package event

import (
	"encoding/json"
	"reflect"
	"testing"

	"github.com/google/uuid"
)

func getTestEvent() *Event {
	return &Event{
		ID:       uuid.MustParse("688a264e-5f85-40f8-bd13-afc42fcd5c7a"),
		EntityID: uuid.MustParse("688a264e-5f85-40f8-bd13-afc42fcd5c7b"),
		Type:     "add",
	}
}

func getTestEventAsByteArray() []byte {
	testEventAsByteArray, err := json.Marshal(getTestEvent())
	if err != nil {
		panic(err)
	}

	return testEventAsByteArray
}

func Test_getEventFromPayload(t *testing.T) {
	type args struct {
		payload []byte
	}
	tests := []struct {
		name    string
		args    args
		want    *Event
		wantErr bool
	}{
		{
			name: "should parse valid event",
			args: args{
				payload: getTestEventAsByteArray(),
			},
			want:    getTestEvent(),
			wantErr: false,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := getEventFromPayload(tt.args.payload)
			if (err != nil) != tt.wantErr {
				t.Errorf("getEventFromPayload() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("getEventFromPayload() = %v, want %v", got, tt.want)
			}
		})
	}
}
