package event

import (
	"encoding/json"

	"github.com/google/uuid"
)

// Event is a event that can be published via the event service as payload.
type Event struct {
	ID       uuid.UUID `json:"id,omitempty"`
	EntityID uuid.UUID `json:"entity_id,omitempty"`
	Type     string    `json:"type,omitempty"`
}

func getEventFromPayload(payload []byte) (*Event, error) {
	event := &Event{}
	err := json.Unmarshal(payload, event)
	if err != nil {
		return nil, err
	}

	return event, nil
}
