//
// Copyright 2016 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.12.4
// source: github.com/openconfig/gnmi/proto/gnmi/gnmi.proto

// Package gNMI defines a service specification for the gRPC Network Management
// Interface. This interface is defined to be a standard interface via which
// a network management system ("client") can subscribe to state values,
// retrieve snapshots of state information, and manipulate the state of a data
// tree supported by a device ("target").
//
// This document references the gNMI Specification which can be found at
// http://github.com/openconfig/reference/blob/master/rpc/gnmi

package gnmi

import (
	descriptor "github.com/golang/protobuf/protoc-gen-go/descriptor"
	any "github.com/golang/protobuf/ptypes/any"
	gnmi_ext "github.com/openconfig/gnmi/proto/gnmi_ext"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Encoding defines the value encoding formats that are supported by the gNMI
// protocol. These encodings are used by both the client (when sending Set
// messages to modify the state of the target) and the target when serializing
// data to be returned to the client (in both Subscribe and Get RPCs).
// Reference: gNMI Specification Section 2.3
type Encoding int32

const (
	Encoding_JSON      Encoding = 0 // JSON encoded text.
	Encoding_BYTES     Encoding = 1 // Arbitrarily encoded bytes.
	Encoding_PROTO     Encoding = 2 // Encoded according to out-of-band agreed Protobuf.
	Encoding_ASCII     Encoding = 3 // ASCII text of an out-of-band agreed format.
	Encoding_JSON_IETF Encoding = 4 // JSON encoded text as per RFC7951.
)

// Enum value maps for Encoding.
var (
	Encoding_name = map[int32]string{
		0: "JSON",
		1: "BYTES",
		2: "PROTO",
		3: "ASCII",
		4: "JSON_IETF",
	}
	Encoding_value = map[string]int32{
		"JSON":      0,
		"BYTES":     1,
		"PROTO":     2,
		"ASCII":     3,
		"JSON_IETF": 4,
	}
)

func (x Encoding) Enum() *Encoding {
	p := new(Encoding)
	*p = x
	return p
}

func (x Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[0].Descriptor()
}

func (Encoding) Type() protoreflect.EnumType {
	return &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[0]
}

func (x Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Encoding.Descriptor instead.
func (Encoding) EnumDescriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{0}
}

// SubscriptionMode is the mode of the subscription, specifying how the
// target must return values in a subscription.
// Reference: gNMI Specification Section 3.5.1.3
type SubscriptionMode int32

const (
	SubscriptionMode_TARGET_DEFINED SubscriptionMode = 0 // The target selects the relevant mode for each element.
	SubscriptionMode_ON_CHANGE      SubscriptionMode = 1 // The target sends an update on element value change.
	SubscriptionMode_SAMPLE         SubscriptionMode = 2 // The target samples values according to the interval.
)

// Enum value maps for SubscriptionMode.
var (
	SubscriptionMode_name = map[int32]string{
		0: "TARGET_DEFINED",
		1: "ON_CHANGE",
		2: "SAMPLE",
	}
	SubscriptionMode_value = map[string]int32{
		"TARGET_DEFINED": 0,
		"ON_CHANGE":      1,
		"SAMPLE":         2,
	}
)

func (x SubscriptionMode) Enum() *SubscriptionMode {
	p := new(SubscriptionMode)
	*p = x
	return p
}

func (x SubscriptionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubscriptionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[1].Descriptor()
}

func (SubscriptionMode) Type() protoreflect.EnumType {
	return &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[1]
}

func (x SubscriptionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubscriptionMode.Descriptor instead.
func (SubscriptionMode) EnumDescriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{1}
}

// Mode of the subscription.
type SubscriptionList_Mode int32

const (
	SubscriptionList_STREAM SubscriptionList_Mode = 0 // Values streamed by the target (Sec. 3.5.1.5.2).
	SubscriptionList_ONCE   SubscriptionList_Mode = 1 // Values sent once-off by the target (Sec. 3.5.1.5.1).
	SubscriptionList_POLL   SubscriptionList_Mode = 2 // Values sent in response to a poll request (Sec. 3.5.1.5.3).
)

// Enum value maps for SubscriptionList_Mode.
var (
	SubscriptionList_Mode_name = map[int32]string{
		0: "STREAM",
		1: "ONCE",
		2: "POLL",
	}
	SubscriptionList_Mode_value = map[string]int32{
		"STREAM": 0,
		"ONCE":   1,
		"POLL":   2,
	}
)

func (x SubscriptionList_Mode) Enum() *SubscriptionList_Mode {
	p := new(SubscriptionList_Mode)
	*p = x
	return p
}

func (x SubscriptionList_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubscriptionList_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[2].Descriptor()
}

func (SubscriptionList_Mode) Type() protoreflect.EnumType {
	return &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[2]
}

func (x SubscriptionList_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubscriptionList_Mode.Descriptor instead.
func (SubscriptionList_Mode) EnumDescriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{12, 0}
}

// The operation that was associated with the Path specified.
type UpdateResult_Operation int32

const (
	UpdateResult_INVALID UpdateResult_Operation = 0
	UpdateResult_DELETE  UpdateResult_Operation = 1 // The result relates to a delete of Path.
	UpdateResult_REPLACE UpdateResult_Operation = 2 // The result relates to a replace of Path.
	UpdateResult_UPDATE  UpdateResult_Operation = 3 // The result relates to an update of Path.
)

// Enum value maps for UpdateResult_Operation.
var (
	UpdateResult_Operation_name = map[int32]string{
		0: "INVALID",
		1: "DELETE",
		2: "REPLACE",
		3: "UPDATE",
	}
	UpdateResult_Operation_value = map[string]int32{
		"INVALID": 0,
		"DELETE":  1,
		"REPLACE": 2,
		"UPDATE":  3,
	}
)

func (x UpdateResult_Operation) Enum() *UpdateResult_Operation {
	p := new(UpdateResult_Operation)
	*p = x
	return p
}

func (x UpdateResult_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpdateResult_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[3].Descriptor()
}

func (UpdateResult_Operation) Type() protoreflect.EnumType {
	return &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[3]
}

func (x UpdateResult_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpdateResult_Operation.Descriptor instead.
func (UpdateResult_Operation) EnumDescriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{19, 0}
}

// Type of elements within the data tree.
type GetRequest_DataType int32

const (
	GetRequest_ALL    GetRequest_DataType = 0 // All data elements.
	GetRequest_CONFIG GetRequest_DataType = 1 // Config (rw) only elements.
	GetRequest_STATE  GetRequest_DataType = 2 // State (ro) only elements.
	// Data elements marked in the schema as operational. This refers to data
	// elements whose value relates to the state of processes or interactions
	// running on the device.
	GetRequest_OPERATIONAL GetRequest_DataType = 3
)

// Enum value maps for GetRequest_DataType.
var (
	GetRequest_DataType_name = map[int32]string{
		0: "ALL",
		1: "CONFIG",
		2: "STATE",
		3: "OPERATIONAL",
	}
	GetRequest_DataType_value = map[string]int32{
		"ALL":         0,
		"CONFIG":      1,
		"STATE":       2,
		"OPERATIONAL": 3,
	}
)

func (x GetRequest_DataType) Enum() *GetRequest_DataType {
	p := new(GetRequest_DataType)
	*p = x
	return p
}

func (x GetRequest_DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetRequest_DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[4].Descriptor()
}

func (GetRequest_DataType) Type() protoreflect.EnumType {
	return &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes[4]
}

func (x GetRequest_DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetRequest_DataType.Descriptor instead.
func (GetRequest_DataType) EnumDescriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{20, 0}
}

// Notification is a re-usable message that is used to encode data from the
// target to the client. A Notification carries two types of changes to the data
// tree:
//  - Deleted values (delete) - a set of paths that have been removed from the
//    data tree.
//  - Updated values (update) - a set of path-value pairs indicating the path
//    whose value has changed in the data tree.
// Reference: gNMI Specification Section 2.1
type Notification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"` // Timestamp in nanoseconds since Epoch.
	Prefix    *Path `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`        // Prefix used for paths in the message.
	// An alias for the path specified in the prefix field.
	// Reference: gNMI Specification Section 2.4.2
	Alias  string    `protobuf:"bytes,3,opt,name=alias,proto3" json:"alias,omitempty"`
	Update []*Update `protobuf:"bytes,4,rep,name=update,proto3" json:"update,omitempty"` // Data elements that have changed values.
	Delete []*Path   `protobuf:"bytes,5,rep,name=delete,proto3" json:"delete,omitempty"` // Data elements that have been deleted.
	// This notification contains a set of paths that are always updated together
	// referenced by a globally unique prefix.
	Atomic bool `protobuf:"varint,6,opt,name=atomic,proto3" json:"atomic,omitempty"`
}

func (x *Notification) Reset() {
	*x = Notification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Notification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Notification) ProtoMessage() {}

func (x *Notification) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Notification.ProtoReflect.Descriptor instead.
func (*Notification) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{0}
}

func (x *Notification) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Notification) GetPrefix() *Path {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *Notification) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

func (x *Notification) GetUpdate() []*Update {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *Notification) GetDelete() []*Path {
	if x != nil {
		return x.Delete
	}
	return nil
}

func (x *Notification) GetAtomic() bool {
	if x != nil {
		return x.Atomic
	}
	return false
}

// Update is a re-usable message that is used to store a particular Path,
// Value pair.
// Reference: gNMI Specification Section 2.1
type Update struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path *Path `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"` // The path (key) for the update.
	// Deprecated: Do not use.
	Value      *Value      `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`            // The value (value) for the update.
	Val        *TypedValue `protobuf:"bytes,3,opt,name=val,proto3" json:"val,omitempty"`                // The explicitly typed update value.
	Duplicates uint32      `protobuf:"varint,4,opt,name=duplicates,proto3" json:"duplicates,omitempty"` // Number of coalesced duplicates.
}

func (x *Update) Reset() {
	*x = Update{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Update) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Update) ProtoMessage() {}

func (x *Update) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Update.ProtoReflect.Descriptor instead.
func (*Update) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{1}
}

func (x *Update) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

// Deprecated: Do not use.
func (x *Update) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Update) GetVal() *TypedValue {
	if x != nil {
		return x.Val
	}
	return nil
}

func (x *Update) GetDuplicates() uint32 {
	if x != nil {
		return x.Duplicates
	}
	return 0
}

// TypedValue is used to encode a value being sent between the client and
// target (originated by either entity).
type TypedValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of the fields within the val oneof is populated with the value
	// of the update. The type of the value being included in the Update
	// determines which field should be populated. In the case that the
	// encoding is a particular form of the base protobuf type, a specific
	// field is used to store the value (e.g., json_val).
	//
	// Types that are assignable to Value:
	//	*TypedValue_StringVal
	//	*TypedValue_IntVal
	//	*TypedValue_UintVal
	//	*TypedValue_BoolVal
	//	*TypedValue_BytesVal
	//	*TypedValue_FloatVal
	//	*TypedValue_DecimalVal
	//	*TypedValue_LeaflistVal
	//	*TypedValue_AnyVal
	//	*TypedValue_JsonVal
	//	*TypedValue_JsonIetfVal
	//	*TypedValue_AsciiVal
	//	*TypedValue_ProtoBytes
	Value isTypedValue_Value `protobuf_oneof:"value"`
}

func (x *TypedValue) Reset() {
	*x = TypedValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TypedValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypedValue) ProtoMessage() {}

func (x *TypedValue) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypedValue.ProtoReflect.Descriptor instead.
func (*TypedValue) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{2}
}

func (m *TypedValue) GetValue() isTypedValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *TypedValue) GetStringVal() string {
	if x, ok := x.GetValue().(*TypedValue_StringVal); ok {
		return x.StringVal
	}
	return ""
}

func (x *TypedValue) GetIntVal() int64 {
	if x, ok := x.GetValue().(*TypedValue_IntVal); ok {
		return x.IntVal
	}
	return 0
}

func (x *TypedValue) GetUintVal() uint64 {
	if x, ok := x.GetValue().(*TypedValue_UintVal); ok {
		return x.UintVal
	}
	return 0
}

func (x *TypedValue) GetBoolVal() bool {
	if x, ok := x.GetValue().(*TypedValue_BoolVal); ok {
		return x.BoolVal
	}
	return false
}

func (x *TypedValue) GetBytesVal() []byte {
	if x, ok := x.GetValue().(*TypedValue_BytesVal); ok {
		return x.BytesVal
	}
	return nil
}

func (x *TypedValue) GetFloatVal() float32 {
	if x, ok := x.GetValue().(*TypedValue_FloatVal); ok {
		return x.FloatVal
	}
	return 0
}

func (x *TypedValue) GetDecimalVal() *Decimal64 {
	if x, ok := x.GetValue().(*TypedValue_DecimalVal); ok {
		return x.DecimalVal
	}
	return nil
}

func (x *TypedValue) GetLeaflistVal() *ScalarArray {
	if x, ok := x.GetValue().(*TypedValue_LeaflistVal); ok {
		return x.LeaflistVal
	}
	return nil
}

func (x *TypedValue) GetAnyVal() *any.Any {
	if x, ok := x.GetValue().(*TypedValue_AnyVal); ok {
		return x.AnyVal
	}
	return nil
}

func (x *TypedValue) GetJsonVal() []byte {
	if x, ok := x.GetValue().(*TypedValue_JsonVal); ok {
		return x.JsonVal
	}
	return nil
}

func (x *TypedValue) GetJsonIetfVal() []byte {
	if x, ok := x.GetValue().(*TypedValue_JsonIetfVal); ok {
		return x.JsonIetfVal
	}
	return nil
}

func (x *TypedValue) GetAsciiVal() string {
	if x, ok := x.GetValue().(*TypedValue_AsciiVal); ok {
		return x.AsciiVal
	}
	return ""
}

func (x *TypedValue) GetProtoBytes() []byte {
	if x, ok := x.GetValue().(*TypedValue_ProtoBytes); ok {
		return x.ProtoBytes
	}
	return nil
}

type isTypedValue_Value interface {
	isTypedValue_Value()
}

type TypedValue_StringVal struct {
	StringVal string `protobuf:"bytes,1,opt,name=string_val,json=stringVal,proto3,oneof"` // String value.
}

type TypedValue_IntVal struct {
	IntVal int64 `protobuf:"varint,2,opt,name=int_val,json=intVal,proto3,oneof"` // Integer value.
}

type TypedValue_UintVal struct {
	UintVal uint64 `protobuf:"varint,3,opt,name=uint_val,json=uintVal,proto3,oneof"` // Unsigned integer value.
}

type TypedValue_BoolVal struct {
	BoolVal bool `protobuf:"varint,4,opt,name=bool_val,json=boolVal,proto3,oneof"` // Bool value.
}

type TypedValue_BytesVal struct {
	BytesVal []byte `protobuf:"bytes,5,opt,name=bytes_val,json=bytesVal,proto3,oneof"` // Arbitrary byte sequence value.
}

type TypedValue_FloatVal struct {
	FloatVal float32 `protobuf:"fixed32,6,opt,name=float_val,json=floatVal,proto3,oneof"` // Floating point value.
}

type TypedValue_DecimalVal struct {
	DecimalVal *Decimal64 `protobuf:"bytes,7,opt,name=decimal_val,json=decimalVal,proto3,oneof"` // Decimal64 encoded value.
}

type TypedValue_LeaflistVal struct {
	LeaflistVal *ScalarArray `protobuf:"bytes,8,opt,name=leaflist_val,json=leaflistVal,proto3,oneof"` // Mixed type scalar array value.
}

type TypedValue_AnyVal struct {
	AnyVal *any.Any `protobuf:"bytes,9,opt,name=any_val,json=anyVal,proto3,oneof"` // protobuf.Any encoded bytes.
}

type TypedValue_JsonVal struct {
	JsonVal []byte `protobuf:"bytes,10,opt,name=json_val,json=jsonVal,proto3,oneof"` // JSON-encoded text.
}

type TypedValue_JsonIetfVal struct {
	JsonIetfVal []byte `protobuf:"bytes,11,opt,name=json_ietf_val,json=jsonIetfVal,proto3,oneof"` // JSON-encoded text per RFC7951.
}

type TypedValue_AsciiVal struct {
	AsciiVal string `protobuf:"bytes,12,opt,name=ascii_val,json=asciiVal,proto3,oneof"` // Arbitrary ASCII text.
}

type TypedValue_ProtoBytes struct {
	// Protobuf binary encoded bytes. The message type is not included.
	// See the specification at
	// github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
	// for a complete specification.
	ProtoBytes []byte `protobuf:"bytes,13,opt,name=proto_bytes,json=protoBytes,proto3,oneof"`
}

func (*TypedValue_StringVal) isTypedValue_Value() {}

func (*TypedValue_IntVal) isTypedValue_Value() {}

func (*TypedValue_UintVal) isTypedValue_Value() {}

func (*TypedValue_BoolVal) isTypedValue_Value() {}

func (*TypedValue_BytesVal) isTypedValue_Value() {}

func (*TypedValue_FloatVal) isTypedValue_Value() {}

func (*TypedValue_DecimalVal) isTypedValue_Value() {}

func (*TypedValue_LeaflistVal) isTypedValue_Value() {}

func (*TypedValue_AnyVal) isTypedValue_Value() {}

func (*TypedValue_JsonVal) isTypedValue_Value() {}

func (*TypedValue_JsonIetfVal) isTypedValue_Value() {}

func (*TypedValue_AsciiVal) isTypedValue_Value() {}

func (*TypedValue_ProtoBytes) isTypedValue_Value() {}

// Path encodes a data tree path as a series of repeated strings, with
// each element of the path representing a data tree node name and the
// associated attributes.
// Reference: gNMI Specification Section 2.2.2.
type Path struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Elements of the path are no longer encoded as a string, but rather within
	// the elem field as a PathElem message.
	//
	// Deprecated: Do not use.
	Element []string    `protobuf:"bytes,1,rep,name=element,proto3" json:"element,omitempty"`
	Origin  string      `protobuf:"bytes,2,opt,name=origin,proto3" json:"origin,omitempty"` // Label to disambiguate path.
	Elem    []*PathElem `protobuf:"bytes,3,rep,name=elem,proto3" json:"elem,omitempty"`     // Elements of the path.
	Target  string      `protobuf:"bytes,4,opt,name=target,proto3" json:"target,omitempty"` // The name of the target
}

func (x *Path) Reset() {
	*x = Path{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Path) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Path) ProtoMessage() {}

func (x *Path) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Path.ProtoReflect.Descriptor instead.
func (*Path) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{3}
}

// Deprecated: Do not use.
func (x *Path) GetElement() []string {
	if x != nil {
		return x.Element
	}
	return nil
}

func (x *Path) GetOrigin() string {
	if x != nil {
		return x.Origin
	}
	return ""
}

func (x *Path) GetElem() []*PathElem {
	if x != nil {
		return x.Elem
	}
	return nil
}

func (x *Path) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

// PathElem encodes an element of a gNMI path, along with any attributes (keys)
// that may be associated with it.
// Reference: gNMI Specification Section 2.2.2.
type PathElem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                                                                                       // The name of the element in the path.
	Key  map[string]string `protobuf:"bytes,2,rep,name=key,proto3" json:"key,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Map of key (attribute) name to value.
}

func (x *PathElem) Reset() {
	*x = PathElem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PathElem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PathElem) ProtoMessage() {}

func (x *PathElem) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PathElem.ProtoReflect.Descriptor instead.
func (*PathElem) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{4}
}

func (x *PathElem) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PathElem) GetKey() map[string]string {
	if x != nil {
		return x.Key
	}
	return nil
}

// Value encodes a data tree node's value - along with the way in which
// the value is encoded. This message is deprecated by gNMI 0.3.0.
// Reference: gNMI Specification Section 2.2.3.
//
// Deprecated: Do not use.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value []byte   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`                   // Value of the variable being transmitted.
	Type  Encoding `protobuf:"varint,2,opt,name=type,proto3,enum=gnmi.Encoding" json:"type,omitempty"` // Encoding used for the value field.
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{5}
}

func (x *Value) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Value) GetType() Encoding {
	if x != nil {
		return x.Type
	}
	return Encoding_JSON
}

// Error message previously utilised to return errors to the client. Deprecated
// in favour of using the google.golang.org/genproto/googleapis/rpc/status
// message in the RPC response.
// Reference: gNMI Specification Section 2.5
//
// Deprecated: Do not use.
type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Code    uint32   `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`      // Canonical gRPC error code.
	Message string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"` // Human readable error.
	Data    *any.Any `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`       // Optional additional information.
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{6}
}

func (x *Error) GetCode() uint32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Error) GetData() *any.Any {
	if x != nil {
		return x.Data
	}
	return nil
}

// Decimal64 is used to encode a fixed precision decimal number. The value
// is expressed as a set of digits with the precision specifying the
// number of digits following the decimal point in the digit set.
type Decimal64 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Digits    int64  `protobuf:"varint,1,opt,name=digits,proto3" json:"digits,omitempty"`       // Set of digits.
	Precision uint32 `protobuf:"varint,2,opt,name=precision,proto3" json:"precision,omitempty"` // Number of digits following the decimal point.
}

func (x *Decimal64) Reset() {
	*x = Decimal64{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Decimal64) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decimal64) ProtoMessage() {}

func (x *Decimal64) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decimal64.ProtoReflect.Descriptor instead.
func (*Decimal64) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{7}
}

func (x *Decimal64) GetDigits() int64 {
	if x != nil {
		return x.Digits
	}
	return 0
}

func (x *Decimal64) GetPrecision() uint32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

// ScalarArray is used to encode a mixed-type array of values.
type ScalarArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of elements within the array. Each TypedValue message should
	// specify only elements that have a field identifier of 1-7 (i.e., the
	// values are scalar values).
	Element []*TypedValue `protobuf:"bytes,1,rep,name=element,proto3" json:"element,omitempty"`
}

func (x *ScalarArray) Reset() {
	*x = ScalarArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScalarArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScalarArray) ProtoMessage() {}

func (x *ScalarArray) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScalarArray.ProtoReflect.Descriptor instead.
func (*ScalarArray) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{8}
}

func (x *ScalarArray) GetElement() []*TypedValue {
	if x != nil {
		return x.Element
	}
	return nil
}

// SubscribeRequest is the message sent by the client to the target when
// initiating a subscription to a set of paths within the data tree. The
// request field must be populated and the initial message must specify a
// SubscriptionList to initiate a subscription. The message is subsequently
// used to define aliases or trigger polled data to be sent by the target.
// Reference: gNMI Specification Section 3.5.1.1
type SubscribeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//	*SubscribeRequest_Subscribe
	//	*SubscribeRequest_Poll
	//	*SubscribeRequest_Aliases
	Request isSubscribeRequest_Request `protobuf_oneof:"request"`
	// Extension messages associated with the SubscribeRequest. See the
	// gNMI extension specification for further definition.
	Extension []*gnmi_ext.Extension `protobuf:"bytes,5,rep,name=extension,proto3" json:"extension,omitempty"`
}

func (x *SubscribeRequest) Reset() {
	*x = SubscribeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeRequest) ProtoMessage() {}

func (x *SubscribeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeRequest.ProtoReflect.Descriptor instead.
func (*SubscribeRequest) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{9}
}

func (m *SubscribeRequest) GetRequest() isSubscribeRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *SubscribeRequest) GetSubscribe() *SubscriptionList {
	if x, ok := x.GetRequest().(*SubscribeRequest_Subscribe); ok {
		return x.Subscribe
	}
	return nil
}

func (x *SubscribeRequest) GetPoll() *Poll {
	if x, ok := x.GetRequest().(*SubscribeRequest_Poll); ok {
		return x.Poll
	}
	return nil
}

func (x *SubscribeRequest) GetAliases() *AliasList {
	if x, ok := x.GetRequest().(*SubscribeRequest_Aliases); ok {
		return x.Aliases
	}
	return nil
}

func (x *SubscribeRequest) GetExtension() []*gnmi_ext.Extension {
	if x != nil {
		return x.Extension
	}
	return nil
}

type isSubscribeRequest_Request interface {
	isSubscribeRequest_Request()
}

type SubscribeRequest_Subscribe struct {
	Subscribe *SubscriptionList `protobuf:"bytes,1,opt,name=subscribe,proto3,oneof"` // Specify the paths within a subscription.
}

type SubscribeRequest_Poll struct {
	Poll *Poll `protobuf:"bytes,3,opt,name=poll,proto3,oneof"` // Trigger a polled update.
}

type SubscribeRequest_Aliases struct {
	Aliases *AliasList `protobuf:"bytes,4,opt,name=aliases,proto3,oneof"` // Aliases to be created.
}

func (*SubscribeRequest_Subscribe) isSubscribeRequest_Request() {}

func (*SubscribeRequest_Poll) isSubscribeRequest_Request() {}

func (*SubscribeRequest_Aliases) isSubscribeRequest_Request() {}

// Poll is sent within a SubscribeRequest to trigger the device to
// send telemetry updates for the paths that are associated with the
// subscription.
// Reference: gNMI Specification Section Section 3.5.1.4
type Poll struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Poll) Reset() {
	*x = Poll{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Poll) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Poll) ProtoMessage() {}

func (x *Poll) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Poll.ProtoReflect.Descriptor instead.
func (*Poll) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{10}
}

// SubscribeResponse is the message used by the target within a Subscribe RPC.
// The target includes a Notification message which is used to transmit values
// of the path(s) that are associated with the subscription. The same message
// is to indicate that the target has sent all data values once (is
// synchronized).
// Reference: gNMI Specification Section 3.5.1.4
type SubscribeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Response:
	//	*SubscribeResponse_Update
	//	*SubscribeResponse_SyncResponse
	//	*SubscribeResponse_Error
	Response isSubscribeResponse_Response `protobuf_oneof:"response"`
	// Extension messages associated with the SubscribeResponse. See the
	// gNMI extension specification for further definition.
	Extension []*gnmi_ext.Extension `protobuf:"bytes,5,rep,name=extension,proto3" json:"extension,omitempty"`
}

func (x *SubscribeResponse) Reset() {
	*x = SubscribeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeResponse) ProtoMessage() {}

func (x *SubscribeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeResponse.ProtoReflect.Descriptor instead.
func (*SubscribeResponse) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{11}
}

func (m *SubscribeResponse) GetResponse() isSubscribeResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *SubscribeResponse) GetUpdate() *Notification {
	if x, ok := x.GetResponse().(*SubscribeResponse_Update); ok {
		return x.Update
	}
	return nil
}

func (x *SubscribeResponse) GetSyncResponse() bool {
	if x, ok := x.GetResponse().(*SubscribeResponse_SyncResponse); ok {
		return x.SyncResponse
	}
	return false
}

// Deprecated: Do not use.
func (x *SubscribeResponse) GetError() *Error {
	if x, ok := x.GetResponse().(*SubscribeResponse_Error); ok {
		return x.Error
	}
	return nil
}

func (x *SubscribeResponse) GetExtension() []*gnmi_ext.Extension {
	if x != nil {
		return x.Extension
	}
	return nil
}

type isSubscribeResponse_Response interface {
	isSubscribeResponse_Response()
}

type SubscribeResponse_Update struct {
	Update *Notification `protobuf:"bytes,1,opt,name=update,proto3,oneof"` // Changed or sampled value for a path.
}

type SubscribeResponse_SyncResponse struct {
	// Indicate target has sent all values associated with the subscription
	// at least once.
	SyncResponse bool `protobuf:"varint,3,opt,name=sync_response,json=syncResponse,proto3,oneof"`
}

type SubscribeResponse_Error struct {
	// Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
	//
	// Deprecated: Do not use.
	Error *Error `protobuf:"bytes,4,opt,name=error,proto3,oneof"`
}

func (*SubscribeResponse_Update) isSubscribeResponse_Response() {}

func (*SubscribeResponse_SyncResponse) isSubscribeResponse_Response() {}

func (*SubscribeResponse_Error) isSubscribeResponse_Response() {}

// SubscriptionList is used within a Subscribe message to specify the list of
// paths that the client wishes to subscribe to. The message consists of a
// list of (possibly prefixed) paths, and options that relate to the
// subscription.
// Reference: gNMI Specification Section 3.5.1.2
type SubscriptionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Prefix       *Path           `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`             // Prefix used for paths.
	Subscription []*Subscription `protobuf:"bytes,2,rep,name=subscription,proto3" json:"subscription,omitempty"` // Set of subscriptions to create.
	// Whether target defined aliases are allowed within the subscription.
	UseAliases bool                  `protobuf:"varint,3,opt,name=use_aliases,json=useAliases,proto3" json:"use_aliases,omitempty"`
	Qos        *QOSMarking           `protobuf:"bytes,4,opt,name=qos,proto3" json:"qos,omitempty"` // DSCP marking to be used.
	Mode       SubscriptionList_Mode `protobuf:"varint,5,opt,name=mode,proto3,enum=gnmi.SubscriptionList_Mode" json:"mode,omitempty"`
	// Whether elements of the schema that are marked as eligible for aggregation
	// should be aggregated or not.
	AllowAggregation bool `protobuf:"varint,6,opt,name=allow_aggregation,json=allowAggregation,proto3" json:"allow_aggregation,omitempty"`
	// The set of schemas that define the elements of the data tree that should
	// be sent by the target.
	UseModels []*ModelData `protobuf:"bytes,7,rep,name=use_models,json=useModels,proto3" json:"use_models,omitempty"`
	// The encoding that the target should use within the Notifications generated
	// corresponding to the SubscriptionList.
	Encoding Encoding `protobuf:"varint,8,opt,name=encoding,proto3,enum=gnmi.Encoding" json:"encoding,omitempty"`
	// An optional field to specify that only updates to current state should be
	// sent to a client. If set, the initial state is not sent to the client but
	// rather only the sync message followed by any subsequent updates to the
	// current state. For ONCE and POLL modes, this causes the server to send only
	// the sync message (Sec. 3.5.2.3).
	UpdatesOnly bool `protobuf:"varint,9,opt,name=updates_only,json=updatesOnly,proto3" json:"updates_only,omitempty"`
}

func (x *SubscriptionList) Reset() {
	*x = SubscriptionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscriptionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscriptionList) ProtoMessage() {}

func (x *SubscriptionList) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscriptionList.ProtoReflect.Descriptor instead.
func (*SubscriptionList) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{12}
}

func (x *SubscriptionList) GetPrefix() *Path {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *SubscriptionList) GetSubscription() []*Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

func (x *SubscriptionList) GetUseAliases() bool {
	if x != nil {
		return x.UseAliases
	}
	return false
}

func (x *SubscriptionList) GetQos() *QOSMarking {
	if x != nil {
		return x.Qos
	}
	return nil
}

func (x *SubscriptionList) GetMode() SubscriptionList_Mode {
	if x != nil {
		return x.Mode
	}
	return SubscriptionList_STREAM
}

func (x *SubscriptionList) GetAllowAggregation() bool {
	if x != nil {
		return x.AllowAggregation
	}
	return false
}

func (x *SubscriptionList) GetUseModels() []*ModelData {
	if x != nil {
		return x.UseModels
	}
	return nil
}

func (x *SubscriptionList) GetEncoding() Encoding {
	if x != nil {
		return x.Encoding
	}
	return Encoding_JSON
}

func (x *SubscriptionList) GetUpdatesOnly() bool {
	if x != nil {
		return x.UpdatesOnly
	}
	return false
}

// Subscription is a single request within a SubscriptionList. The path
// specified is interpreted (along with the prefix) as the elements of the data
// tree that the client is subscribing to. The mode determines how the target
// should trigger updates to be sent.
// Reference: gNMI Specification Section 3.5.1.3
type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path           *Path            `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`                                            // The data tree path.
	Mode           SubscriptionMode `protobuf:"varint,2,opt,name=mode,proto3,enum=gnmi.SubscriptionMode" json:"mode,omitempty"`                // Subscription mode to be used.
	SampleInterval uint64           `protobuf:"varint,3,opt,name=sample_interval,json=sampleInterval,proto3" json:"sample_interval,omitempty"` // ns between samples in SAMPLE mode.
	// Indicates whether values that have not changed should be sent in a SAMPLE
	// subscription.
	SuppressRedundant bool `protobuf:"varint,4,opt,name=suppress_redundant,json=suppressRedundant,proto3" json:"suppress_redundant,omitempty"`
	// Specifies the maximum allowable silent period in nanoseconds when
	// suppress_redundant is in use. The target should send a value at least once
	// in the period specified.
	HeartbeatInterval uint64 `protobuf:"varint,5,opt,name=heartbeat_interval,json=heartbeatInterval,proto3" json:"heartbeat_interval,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{13}
}

func (x *Subscription) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *Subscription) GetMode() SubscriptionMode {
	if x != nil {
		return x.Mode
	}
	return SubscriptionMode_TARGET_DEFINED
}

func (x *Subscription) GetSampleInterval() uint64 {
	if x != nil {
		return x.SampleInterval
	}
	return 0
}

func (x *Subscription) GetSuppressRedundant() bool {
	if x != nil {
		return x.SuppressRedundant
	}
	return false
}

func (x *Subscription) GetHeartbeatInterval() uint64 {
	if x != nil {
		return x.HeartbeatInterval
	}
	return 0
}

// QOSMarking specifies the DSCP value to be set on transmitted telemetry
// updates from the target.
// Reference: gNMI Specification Section 3.5.1.2
type QOSMarking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Marking uint32 `protobuf:"varint,1,opt,name=marking,proto3" json:"marking,omitempty"`
}

func (x *QOSMarking) Reset() {
	*x = QOSMarking{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QOSMarking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QOSMarking) ProtoMessage() {}

func (x *QOSMarking) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QOSMarking.ProtoReflect.Descriptor instead.
func (*QOSMarking) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{14}
}

func (x *QOSMarking) GetMarking() uint32 {
	if x != nil {
		return x.Marking
	}
	return 0
}

// Alias specifies a data tree path, and an associated string which defines an
// alias which is to be used for this path in the context of the RPC. The alias
// is specified as a string which is prefixed with "#" to disambiguate it from
// data tree element paths.
// Reference: gNMI Specification Section 2.4.2
type Alias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path  *Path  `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`   // The path to be aliased.
	Alias string `protobuf:"bytes,2,opt,name=alias,proto3" json:"alias,omitempty"` // The alias value, a string prefixed by "#".
}

func (x *Alias) Reset() {
	*x = Alias{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Alias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Alias) ProtoMessage() {}

func (x *Alias) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Alias.ProtoReflect.Descriptor instead.
func (*Alias) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{15}
}

func (x *Alias) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *Alias) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

// AliasList specifies a list of aliases. It is used in a SubscribeRequest for
// a client to create a set of aliases that the target is to utilize.
// Reference: gNMI Specification Section 3.5.1.6
type AliasList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Alias []*Alias `protobuf:"bytes,1,rep,name=alias,proto3" json:"alias,omitempty"` // The set of aliases to be created.
}

func (x *AliasList) Reset() {
	*x = AliasList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AliasList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AliasList) ProtoMessage() {}

func (x *AliasList) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AliasList.ProtoReflect.Descriptor instead.
func (*AliasList) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{16}
}

func (x *AliasList) GetAlias() []*Alias {
	if x != nil {
		return x.Alias
	}
	return nil
}

// SetRequest is sent from a client to the target to update values in the data
// tree. Paths are either deleted by the client, or modified by means of being
// updated, or replaced. Where a replace is used, unspecified values are
// considered to be replaced, whereas when update is used the changes are
// considered to be incremental. The set of changes that are specified within
// a single SetRequest are considered to be a transaction.
// Reference: gNMI Specification Section 3.4.1
type SetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Prefix  *Path     `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`   // Prefix used for paths in the message.
	Delete  []*Path   `protobuf:"bytes,2,rep,name=delete,proto3" json:"delete,omitempty"`   // Paths to be deleted from the data tree.
	Replace []*Update `protobuf:"bytes,3,rep,name=replace,proto3" json:"replace,omitempty"` // Updates specifying elements to be replaced.
	Update  []*Update `protobuf:"bytes,4,rep,name=update,proto3" json:"update,omitempty"`   // Updates specifying elements to updated.
	// Extension messages associated with the SetRequest. See the
	// gNMI extension specification for further definition.
	Extension []*gnmi_ext.Extension `protobuf:"bytes,5,rep,name=extension,proto3" json:"extension,omitempty"`
}

func (x *SetRequest) Reset() {
	*x = SetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRequest) ProtoMessage() {}

func (x *SetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetRequest.ProtoReflect.Descriptor instead.
func (*SetRequest) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{17}
}

func (x *SetRequest) GetPrefix() *Path {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *SetRequest) GetDelete() []*Path {
	if x != nil {
		return x.Delete
	}
	return nil
}

func (x *SetRequest) GetReplace() []*Update {
	if x != nil {
		return x.Replace
	}
	return nil
}

func (x *SetRequest) GetUpdate() []*Update {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *SetRequest) GetExtension() []*gnmi_ext.Extension {
	if x != nil {
		return x.Extension
	}
	return nil
}

// SetResponse is the response to a SetRequest, sent from the target to the
// client. It reports the result of the modifications to the data tree that were
// specified by the client. Errors for this RPC should be reported using the
// https://github.com/googleapis/googleapis/blob/master/google/rpc/status.proto
// message in the RPC return. The gnmi.Error message can be used to add additional
// details where required.
// Reference: gNMI Specification Section 3.4.2
type SetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Prefix *Path `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"` // Prefix used for paths.
	// A set of responses specifying the result of the operations specified in
	// the SetRequest.
	Response []*UpdateResult `protobuf:"bytes,2,rep,name=response,proto3" json:"response,omitempty"`
	// Deprecated: Do not use.
	Message   *Error `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`      // The overall status of the transaction.
	Timestamp int64  `protobuf:"varint,4,opt,name=timestamp,proto3" json:"timestamp,omitempty"` // Timestamp of transaction (ns since epoch).
	// Extension messages associated with the SetResponse. See the
	// gNMI extension specification for further definition.
	Extension []*gnmi_ext.Extension `protobuf:"bytes,5,rep,name=extension,proto3" json:"extension,omitempty"`
}

func (x *SetResponse) Reset() {
	*x = SetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetResponse) ProtoMessage() {}

func (x *SetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetResponse.ProtoReflect.Descriptor instead.
func (*SetResponse) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{18}
}

func (x *SetResponse) GetPrefix() *Path {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *SetResponse) GetResponse() []*UpdateResult {
	if x != nil {
		return x.Response
	}
	return nil
}

// Deprecated: Do not use.
func (x *SetResponse) GetMessage() *Error {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *SetResponse) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *SetResponse) GetExtension() []*gnmi_ext.Extension {
	if x != nil {
		return x.Extension
	}
	return nil
}

// UpdateResult is used within the SetResponse message to communicate the
// result of an operation specified within a SetRequest message.
// Reference: gNMI Specification Section 3.4.2
type UpdateResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated timestamp for the UpdateResult, this field has been
	// replaced by the timestamp within the SetResponse message, since
	// all mutations effected by a set should be applied as a single
	// transaction.
	//
	// Deprecated: Do not use.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Path      *Path `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"` // Path associated with the update.
	// Deprecated: Do not use.
	Message *Error                 `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`                         // Status of the update operation.
	Op      UpdateResult_Operation `protobuf:"varint,4,opt,name=op,proto3,enum=gnmi.UpdateResult_Operation" json:"op,omitempty"` // Update operation type.
}

func (x *UpdateResult) Reset() {
	*x = UpdateResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateResult) ProtoMessage() {}

func (x *UpdateResult) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateResult.ProtoReflect.Descriptor instead.
func (*UpdateResult) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{19}
}

// Deprecated: Do not use.
func (x *UpdateResult) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *UpdateResult) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

// Deprecated: Do not use.
func (x *UpdateResult) GetMessage() *Error {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *UpdateResult) GetOp() UpdateResult_Operation {
	if x != nil {
		return x.Op
	}
	return UpdateResult_INVALID
}

// GetRequest is sent when a client initiates a Get RPC. It is used to specify
// the set of data elements for which the target should return a snapshot of
// data. The use_models field specifies the set of schema modules that are to
// be used by the target - where use_models is not specified then the target
// must use all schema models that it has.
// Reference: gNMI Specification Section 3.3.1
type GetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Prefix    *Path               `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`                            // Prefix used for paths.
	Path      []*Path             `protobuf:"bytes,2,rep,name=path,proto3" json:"path,omitempty"`                                // Paths requested by the client.
	Type      GetRequest_DataType `protobuf:"varint,3,opt,name=type,proto3,enum=gnmi.GetRequest_DataType" json:"type,omitempty"` // The type of data being requested.
	Encoding  Encoding            `protobuf:"varint,5,opt,name=encoding,proto3,enum=gnmi.Encoding" json:"encoding,omitempty"`    // Encoding to be used.
	UseModels []*ModelData        `protobuf:"bytes,6,rep,name=use_models,json=useModels,proto3" json:"use_models,omitempty"`     // The schema models to be used.
	// Extension messages associated with the GetRequest. See the
	// gNMI extension specification for further definition.
	Extension []*gnmi_ext.Extension `protobuf:"bytes,7,rep,name=extension,proto3" json:"extension,omitempty"`
}

func (x *GetRequest) Reset() {
	*x = GetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRequest) ProtoMessage() {}

func (x *GetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRequest.ProtoReflect.Descriptor instead.
func (*GetRequest) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{20}
}

func (x *GetRequest) GetPrefix() *Path {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *GetRequest) GetPath() []*Path {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *GetRequest) GetType() GetRequest_DataType {
	if x != nil {
		return x.Type
	}
	return GetRequest_ALL
}

func (x *GetRequest) GetEncoding() Encoding {
	if x != nil {
		return x.Encoding
	}
	return Encoding_JSON
}

func (x *GetRequest) GetUseModels() []*ModelData {
	if x != nil {
		return x.UseModels
	}
	return nil
}

func (x *GetRequest) GetExtension() []*gnmi_ext.Extension {
	if x != nil {
		return x.Extension
	}
	return nil
}

// GetResponse is used by the target to respond to a GetRequest from a client.
// The set of Notifications corresponds to the data values that are requested
// by the client in the GetRequest.
// Reference: gNMI Specification Section 3.3.2
type GetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Notification []*Notification `protobuf:"bytes,1,rep,name=notification,proto3" json:"notification,omitempty"` // Data values.
	// Deprecated: Do not use.
	Error *Error `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"` // Errors that occurred in the Get.
	// Extension messages associated with the GetResponse. See the
	// gNMI extension specification for further definition.
	Extension []*gnmi_ext.Extension `protobuf:"bytes,3,rep,name=extension,proto3" json:"extension,omitempty"`
}

func (x *GetResponse) Reset() {
	*x = GetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResponse) ProtoMessage() {}

func (x *GetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResponse.ProtoReflect.Descriptor instead.
func (*GetResponse) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{21}
}

func (x *GetResponse) GetNotification() []*Notification {
	if x != nil {
		return x.Notification
	}
	return nil
}

// Deprecated: Do not use.
func (x *GetResponse) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *GetResponse) GetExtension() []*gnmi_ext.Extension {
	if x != nil {
		return x.Extension
	}
	return nil
}

// CapabilityRequest is sent by the client in the Capabilities RPC to request
// that the target reports its capabilities.
// Reference: gNMI Specification Section 3.2.1
type CapabilityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Extension messages associated with the CapabilityRequest. See the
	// gNMI extension specification for further definition.
	Extension []*gnmi_ext.Extension `protobuf:"bytes,1,rep,name=extension,proto3" json:"extension,omitempty"`
}

func (x *CapabilityRequest) Reset() {
	*x = CapabilityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilityRequest) ProtoMessage() {}

func (x *CapabilityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilityRequest.ProtoReflect.Descriptor instead.
func (*CapabilityRequest) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{22}
}

func (x *CapabilityRequest) GetExtension() []*gnmi_ext.Extension {
	if x != nil {
		return x.Extension
	}
	return nil
}

// CapabilityResponse is used by the target to report its capabilities to the
// client within the Capabilities RPC.
// Reference: gNMI Specification Section 3.2.2
type CapabilityResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SupportedModels    []*ModelData `protobuf:"bytes,1,rep,name=supported_models,json=supportedModels,proto3" json:"supported_models,omitempty"`                                     // Supported schema models.
	SupportedEncodings []Encoding   `protobuf:"varint,2,rep,packed,name=supported_encodings,json=supportedEncodings,proto3,enum=gnmi.Encoding" json:"supported_encodings,omitempty"` // Supported encodings.
	GNMIVersion        string       `protobuf:"bytes,3,opt,name=gNMI_version,json=gNMIVersion,proto3" json:"gNMI_version,omitempty"`                                                 // Supported gNMI version.
	// Extension messages associated with the CapabilityResponse. See the
	// gNMI extension specification for further definition.
	Extension []*gnmi_ext.Extension `protobuf:"bytes,4,rep,name=extension,proto3" json:"extension,omitempty"`
}

func (x *CapabilityResponse) Reset() {
	*x = CapabilityResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilityResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilityResponse) ProtoMessage() {}

func (x *CapabilityResponse) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilityResponse.ProtoReflect.Descriptor instead.
func (*CapabilityResponse) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{23}
}

func (x *CapabilityResponse) GetSupportedModels() []*ModelData {
	if x != nil {
		return x.SupportedModels
	}
	return nil
}

func (x *CapabilityResponse) GetSupportedEncodings() []Encoding {
	if x != nil {
		return x.SupportedEncodings
	}
	return nil
}

func (x *CapabilityResponse) GetGNMIVersion() string {
	if x != nil {
		return x.GNMIVersion
	}
	return ""
}

func (x *CapabilityResponse) GetExtension() []*gnmi_ext.Extension {
	if x != nil {
		return x.Extension
	}
	return nil
}

// ModelData is used to describe a set of schema modules. It can be used in a
// CapabilityResponse where a target reports the set of modules that it
// supports, and within the SubscribeRequest and GetRequest messages to specify
// the set of models from which data tree elements should be reported.
// Reference: gNMI Specification Section 3.2.3
type ModelData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name         string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                 // Name of the model.
	Organization string `protobuf:"bytes,2,opt,name=organization,proto3" json:"organization,omitempty"` // Organization publishing the model.
	Version      string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`           // Semantic version of the model.
}

func (x *ModelData) Reset() {
	*x = ModelData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelData) ProtoMessage() {}

func (x *ModelData) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelData.ProtoReflect.Descriptor instead.
func (*ModelData) Descriptor() ([]byte, []int) {
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP(), []int{24}
}

func (x *ModelData) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModelData) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *ModelData) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

var file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*descriptor.FileOptions)(nil),
		ExtensionType: (*string)(nil),
		Field:         1001,
		Name:          "gnmi.gnmi_service",
		Tag:           "bytes,1001,opt,name=gnmi_service",
		Filename:      "github.com/openconfig/gnmi/proto/gnmi/gnmi.proto",
	},
}

// Extension fields to descriptor.FileOptions.
var (
	// The gNMI service semantic version.
	//
	// optional string gnmi_service = 1001;
	E_GnmiService = &file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_extTypes[0]
)

var File_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto protoreflect.FileDescriptor

var file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70, 0x65,
	0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x04, 0x67, 0x6e, 0x6d, 0x69, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x67, 0x6e, 0x6d,
	0x69, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74,
	0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xc8, 0x01, 0x0a, 0x0c, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x22,
	0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a,
	0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x24, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x22,
	0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a,
	0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x22, 0x93, 0x01, 0x0a, 0x06, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x25, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x22, 0x0a, 0x03,
	0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6e, 0x6d, 0x69,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x76, 0x61, 0x6c,
	0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73,
	0x22, 0xeb, 0x03, 0x0a, 0x0a, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x1f, 0x0a, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x12, 0x19, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x12, 0x1b, 0x0a, 0x08, 0x75,
	0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x48, 0x00, 0x52,
	0x07, 0x75, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x12, 0x1b, 0x0a, 0x08, 0x62, 0x6f, 0x6f, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x62, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x12, 0x1d, 0x0a, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x76,
	0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x08, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x56, 0x61, 0x6c, 0x12, 0x1d, 0x0a, 0x09, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x76, 0x61,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x08, 0x66, 0x6c, 0x6f, 0x61, 0x74,
	0x56, 0x61, 0x6c, 0x12, 0x32, 0x0a, 0x0b, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x5f, 0x76,
	0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e,
	0x44, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x36, 0x34, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x65, 0x63,
	0x69, 0x6d, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x12, 0x36, 0x0a, 0x0c, 0x6c, 0x65, 0x61, 0x66, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x53, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x41, 0x72, 0x72, 0x61, 0x79,
	0x48, 0x00, 0x52, 0x0b, 0x6c, 0x65, 0x61, 0x66, 0x6c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x12,
	0x2f, 0x0a, 0x07, 0x61, 0x6e, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6e, 0x79, 0x56, 0x61, 0x6c,
	0x12, 0x1b, 0x0a, 0x08, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x6a, 0x73, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x12, 0x24, 0x0a,
	0x0d, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x69, 0x65, 0x74, 0x66, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x49, 0x65, 0x74, 0x66,
	0x56, 0x61, 0x6c, 0x12, 0x1d, 0x0a, 0x09, 0x61, 0x73, 0x63, 0x69, 0x69, 0x5f, 0x76, 0x61, 0x6c,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x61, 0x73, 0x63, 0x69, 0x69, 0x56,
	0x61, 0x6c, 0x12, 0x21, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x78,
	0x0a, 0x04, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x12, 0x22, 0x0a, 0x04,
	0x65, 0x6c, 0x65, 0x6d, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x6e, 0x6d,
	0x69, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x45, 0x6c, 0x65, 0x6d, 0x52, 0x04, 0x65, 0x6c, 0x65, 0x6d,
	0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x81, 0x01, 0x0a, 0x08, 0x50, 0x61, 0x74,
	0x68, 0x45, 0x6c, 0x65, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61,
	0x74, 0x68, 0x45, 0x6c, 0x65, 0x6d, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x1a, 0x36, 0x0a, 0x08, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x45, 0x0a, 0x05,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x22, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x67, 0x6e, 0x6d, 0x69,
	0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x3a,
	0x02, 0x18, 0x01, 0x22, 0x63, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x41, 0x0a, 0x09, 0x44, 0x65, 0x63, 0x69,
	0x6d, 0x61, 0x6c, 0x36, 0x34, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x69, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x64, 0x69, 0x67, 0x69, 0x74, 0x73, 0x12, 0x1c, 0x0a,
	0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x39, 0x0a, 0x0b, 0x53,
	0x63, 0x61, 0x6c, 0x61, 0x72, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x2a, 0x0a, 0x07, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6e,
	0x6d, 0x69, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xd7, 0x01, 0x0a, 0x10, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x09, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x09, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x12, 0x20, 0x0a, 0x04, 0x70, 0x6f, 0x6c, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x6f, 0x6c, 0x6c, 0x48, 0x00, 0x52,
	0x04, 0x70, 0x6f, 0x6c, 0x6c, 0x12, 0x2b, 0x0a, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x41, 0x6c,
	0x69, 0x61, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73,
	0x65, 0x73, 0x12, 0x31, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74,
	0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x22, 0x06, 0x0a, 0x04, 0x50, 0x6f, 0x6c, 0x6c, 0x22, 0xd0, 0x01, 0x0a, 0x11, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c,
	0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x0d,
	0x73, 0x79, 0x6e, 0x63, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42,
	0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x31, 0x0a, 0x09,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb8, 0x03, 0x0a, 0x10,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x22, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x06, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x36, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6e, 0x6d,
	0x69, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x75, 0x73, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x12, 0x22, 0x0a,
	0x03, 0x71, 0x6f, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6e, 0x6d,
	0x69, 0x2e, 0x51, 0x4f, 0x53, 0x4d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x52, 0x03, 0x71, 0x6f,
	0x73, 0x12, 0x2f, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1b, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f,
	0x64, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2e, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x75, 0x73, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12,
	0x2a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0e, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x26,
	0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4f, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x50, 0x4f, 0x4c, 0x4c, 0x10, 0x02, 0x22, 0xe1, 0x01, 0x0a, 0x0c, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74,
	0x68, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x2a, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x2d, 0x0a, 0x12,
	0x73, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x73, 0x75, 0x70, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x68,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65,
	0x61, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0x26, 0x0a, 0x0a, 0x51, 0x4f,
	0x53, 0x4d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x61, 0x72, 0x6b,
	0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6d, 0x61, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x22, 0x3d, 0x0a, 0x05, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x1e, 0x0a, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69,
	0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x61,
	0x6c, 0x69, 0x61, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61,
	0x73, 0x22, 0x2e, 0x0a, 0x09, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x21,
	0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e,
	0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61,
	0x73, 0x22, 0xd5, 0x01, 0x0a, 0x0a, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x22, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x06, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x22, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74, 0x68,
	0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x07, 0x72, 0x65, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x67, 0x6e, 0x6d, 0x69,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x07, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x12, 0x24, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0c, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x06,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x31, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6e, 0x6d, 0x69,
	0x5f, 0x65, 0x78, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x0b, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x22, 0x0a, 0x06, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69,
	0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x2e, 0x0a,
	0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b,
	0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x31, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6e, 0x6d, 0x69,
	0x5f, 0x65, 0x78, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xe8, 0x01, 0x0a, 0x0c, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1e, 0x0a, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d,
	0x69, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e,
	0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x02, 0x6f, 0x70, 0x22, 0x3d, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x10, 0x03, 0x22, 0xcb, 0x02, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52,
	0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1e, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x50, 0x61, 0x74,
	0x68, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x2d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x75, 0x73, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x12, 0x31, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74,
	0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3b, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f,
	0x4e, 0x46, 0x49, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10,
	0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c,
	0x10, 0x03, 0x22, 0x9f, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x36, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x67, 0x6e, 0x6d, 0x69,
	0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x31, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x2e,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x46, 0x0a, 0x11, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x09, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67,
	0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xe7, 0x01, 0x0a,
	0x12, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e,
	0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0f,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12,
	0x3f, 0x0a, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x67,
	0x6e, 0x6d, 0x69, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x67, 0x4e, 0x4d, 0x49, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x67, 0x4e, 0x4d, 0x49, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78,
	0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5d, 0x0a, 0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0x44, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42,
	0x59, 0x54, 0x45, 0x53, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x10,
	0x02, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x53, 0x43, 0x49, 0x49, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x4a, 0x53, 0x4f, 0x4e, 0x5f, 0x49, 0x45, 0x54, 0x46, 0x10, 0x04, 0x2a, 0x41, 0x0a, 0x10, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x12, 0x0a, 0x0e, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x41, 0x4d, 0x50, 0x4c, 0x45, 0x10, 0x02, 0x32, 0xe3,
	0x01, 0x0a, 0x04, 0x67, 0x4e, 0x4d, 0x49, 0x12, 0x41, 0x0a, 0x0c, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x17, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x18, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x03, 0x47, 0x65,
	0x74, 0x12, 0x10, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x11, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x03, 0x53, 0x65, 0x74, 0x12, 0x10, 0x2e,
	0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x11, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x40, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12,
	0x16, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x17, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x28, 0x01, 0x30, 0x01, 0x3a, 0x40, 0x0a, 0x0c, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x67, 0x6e, 0x6d, 0x69, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x53, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42,
	0x09, 0x47, 0x6e, 0x6d, 0x69, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x25, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6e, 0x6d, 0x69, 0xca, 0x3e, 0x05, 0x30, 0x2e, 0x37, 0x2e, 0x30, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescOnce sync.Once
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescData = file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDesc
)

func file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescGZIP() []byte {
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescOnce.Do(func() {
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescData = protoimpl.X.CompressGZIP(file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescData)
	})
	return file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDescData
}

var file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_goTypes = []interface{}{
	(Encoding)(0),                  // 0: gnmi.Encoding
	(SubscriptionMode)(0),          // 1: gnmi.SubscriptionMode
	(SubscriptionList_Mode)(0),     // 2: gnmi.SubscriptionList.Mode
	(UpdateResult_Operation)(0),    // 3: gnmi.UpdateResult.Operation
	(GetRequest_DataType)(0),       // 4: gnmi.GetRequest.DataType
	(*Notification)(nil),           // 5: gnmi.Notification
	(*Update)(nil),                 // 6: gnmi.Update
	(*TypedValue)(nil),             // 7: gnmi.TypedValue
	(*Path)(nil),                   // 8: gnmi.Path
	(*PathElem)(nil),               // 9: gnmi.PathElem
	(*Value)(nil),                  // 10: gnmi.Value
	(*Error)(nil),                  // 11: gnmi.Error
	(*Decimal64)(nil),              // 12: gnmi.Decimal64
	(*ScalarArray)(nil),            // 13: gnmi.ScalarArray
	(*SubscribeRequest)(nil),       // 14: gnmi.SubscribeRequest
	(*Poll)(nil),                   // 15: gnmi.Poll
	(*SubscribeResponse)(nil),      // 16: gnmi.SubscribeResponse
	(*SubscriptionList)(nil),       // 17: gnmi.SubscriptionList
	(*Subscription)(nil),           // 18: gnmi.Subscription
	(*QOSMarking)(nil),             // 19: gnmi.QOSMarking
	(*Alias)(nil),                  // 20: gnmi.Alias
	(*AliasList)(nil),              // 21: gnmi.AliasList
	(*SetRequest)(nil),             // 22: gnmi.SetRequest
	(*SetResponse)(nil),            // 23: gnmi.SetResponse
	(*UpdateResult)(nil),           // 24: gnmi.UpdateResult
	(*GetRequest)(nil),             // 25: gnmi.GetRequest
	(*GetResponse)(nil),            // 26: gnmi.GetResponse
	(*CapabilityRequest)(nil),      // 27: gnmi.CapabilityRequest
	(*CapabilityResponse)(nil),     // 28: gnmi.CapabilityResponse
	(*ModelData)(nil),              // 29: gnmi.ModelData
	nil,                            // 30: gnmi.PathElem.KeyEntry
	(*any.Any)(nil),                // 31: google.protobuf.Any
	(*gnmi_ext.Extension)(nil),     // 32: gnmi_ext.Extension
	(*descriptor.FileOptions)(nil), // 33: google.protobuf.FileOptions
}
var file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_depIdxs = []int32{
	8,  // 0: gnmi.Notification.prefix:type_name -> gnmi.Path
	6,  // 1: gnmi.Notification.update:type_name -> gnmi.Update
	8,  // 2: gnmi.Notification.delete:type_name -> gnmi.Path
	8,  // 3: gnmi.Update.path:type_name -> gnmi.Path
	10, // 4: gnmi.Update.value:type_name -> gnmi.Value
	7,  // 5: gnmi.Update.val:type_name -> gnmi.TypedValue
	12, // 6: gnmi.TypedValue.decimal_val:type_name -> gnmi.Decimal64
	13, // 7: gnmi.TypedValue.leaflist_val:type_name -> gnmi.ScalarArray
	31, // 8: gnmi.TypedValue.any_val:type_name -> google.protobuf.Any
	9,  // 9: gnmi.Path.elem:type_name -> gnmi.PathElem
	30, // 10: gnmi.PathElem.key:type_name -> gnmi.PathElem.KeyEntry
	0,  // 11: gnmi.Value.type:type_name -> gnmi.Encoding
	31, // 12: gnmi.Error.data:type_name -> google.protobuf.Any
	7,  // 13: gnmi.ScalarArray.element:type_name -> gnmi.TypedValue
	17, // 14: gnmi.SubscribeRequest.subscribe:type_name -> gnmi.SubscriptionList
	15, // 15: gnmi.SubscribeRequest.poll:type_name -> gnmi.Poll
	21, // 16: gnmi.SubscribeRequest.aliases:type_name -> gnmi.AliasList
	32, // 17: gnmi.SubscribeRequest.extension:type_name -> gnmi_ext.Extension
	5,  // 18: gnmi.SubscribeResponse.update:type_name -> gnmi.Notification
	11, // 19: gnmi.SubscribeResponse.error:type_name -> gnmi.Error
	32, // 20: gnmi.SubscribeResponse.extension:type_name -> gnmi_ext.Extension
	8,  // 21: gnmi.SubscriptionList.prefix:type_name -> gnmi.Path
	18, // 22: gnmi.SubscriptionList.subscription:type_name -> gnmi.Subscription
	19, // 23: gnmi.SubscriptionList.qos:type_name -> gnmi.QOSMarking
	2,  // 24: gnmi.SubscriptionList.mode:type_name -> gnmi.SubscriptionList.Mode
	29, // 25: gnmi.SubscriptionList.use_models:type_name -> gnmi.ModelData
	0,  // 26: gnmi.SubscriptionList.encoding:type_name -> gnmi.Encoding
	8,  // 27: gnmi.Subscription.path:type_name -> gnmi.Path
	1,  // 28: gnmi.Subscription.mode:type_name -> gnmi.SubscriptionMode
	8,  // 29: gnmi.Alias.path:type_name -> gnmi.Path
	20, // 30: gnmi.AliasList.alias:type_name -> gnmi.Alias
	8,  // 31: gnmi.SetRequest.prefix:type_name -> gnmi.Path
	8,  // 32: gnmi.SetRequest.delete:type_name -> gnmi.Path
	6,  // 33: gnmi.SetRequest.replace:type_name -> gnmi.Update
	6,  // 34: gnmi.SetRequest.update:type_name -> gnmi.Update
	32, // 35: gnmi.SetRequest.extension:type_name -> gnmi_ext.Extension
	8,  // 36: gnmi.SetResponse.prefix:type_name -> gnmi.Path
	24, // 37: gnmi.SetResponse.response:type_name -> gnmi.UpdateResult
	11, // 38: gnmi.SetResponse.message:type_name -> gnmi.Error
	32, // 39: gnmi.SetResponse.extension:type_name -> gnmi_ext.Extension
	8,  // 40: gnmi.UpdateResult.path:type_name -> gnmi.Path
	11, // 41: gnmi.UpdateResult.message:type_name -> gnmi.Error
	3,  // 42: gnmi.UpdateResult.op:type_name -> gnmi.UpdateResult.Operation
	8,  // 43: gnmi.GetRequest.prefix:type_name -> gnmi.Path
	8,  // 44: gnmi.GetRequest.path:type_name -> gnmi.Path
	4,  // 45: gnmi.GetRequest.type:type_name -> gnmi.GetRequest.DataType
	0,  // 46: gnmi.GetRequest.encoding:type_name -> gnmi.Encoding
	29, // 47: gnmi.GetRequest.use_models:type_name -> gnmi.ModelData
	32, // 48: gnmi.GetRequest.extension:type_name -> gnmi_ext.Extension
	5,  // 49: gnmi.GetResponse.notification:type_name -> gnmi.Notification
	11, // 50: gnmi.GetResponse.error:type_name -> gnmi.Error
	32, // 51: gnmi.GetResponse.extension:type_name -> gnmi_ext.Extension
	32, // 52: gnmi.CapabilityRequest.extension:type_name -> gnmi_ext.Extension
	29, // 53: gnmi.CapabilityResponse.supported_models:type_name -> gnmi.ModelData
	0,  // 54: gnmi.CapabilityResponse.supported_encodings:type_name -> gnmi.Encoding
	32, // 55: gnmi.CapabilityResponse.extension:type_name -> gnmi_ext.Extension
	33, // 56: gnmi.gnmi_service:extendee -> google.protobuf.FileOptions
	27, // 57: gnmi.gNMI.Capabilities:input_type -> gnmi.CapabilityRequest
	25, // 58: gnmi.gNMI.Get:input_type -> gnmi.GetRequest
	22, // 59: gnmi.gNMI.Set:input_type -> gnmi.SetRequest
	14, // 60: gnmi.gNMI.Subscribe:input_type -> gnmi.SubscribeRequest
	28, // 61: gnmi.gNMI.Capabilities:output_type -> gnmi.CapabilityResponse
	26, // 62: gnmi.gNMI.Get:output_type -> gnmi.GetResponse
	23, // 63: gnmi.gNMI.Set:output_type -> gnmi.SetResponse
	16, // 64: gnmi.gNMI.Subscribe:output_type -> gnmi.SubscribeResponse
	61, // [61:65] is the sub-list for method output_type
	57, // [57:61] is the sub-list for method input_type
	57, // [57:57] is the sub-list for extension type_name
	56, // [56:57] is the sub-list for extension extendee
	0,  // [0:56] is the sub-list for field type_name
}

func init() { file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_init() }
func file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_init() {
	if File_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Notification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Update); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TypedValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Path); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PathElem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Decimal64); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScalarArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Poll); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscriptionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QOSMarking); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Alias); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AliasList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilityResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*TypedValue_StringVal)(nil),
		(*TypedValue_IntVal)(nil),
		(*TypedValue_UintVal)(nil),
		(*TypedValue_BoolVal)(nil),
		(*TypedValue_BytesVal)(nil),
		(*TypedValue_FloatVal)(nil),
		(*TypedValue_DecimalVal)(nil),
		(*TypedValue_LeaflistVal)(nil),
		(*TypedValue_AnyVal)(nil),
		(*TypedValue_JsonVal)(nil),
		(*TypedValue_JsonIetfVal)(nil),
		(*TypedValue_AsciiVal)(nil),
		(*TypedValue_ProtoBytes)(nil),
	}
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*SubscribeRequest_Subscribe)(nil),
		(*SubscribeRequest_Poll)(nil),
		(*SubscribeRequest_Aliases)(nil),
	}
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*SubscribeResponse_Update)(nil),
		(*SubscribeResponse_SyncResponse)(nil),
		(*SubscribeResponse_Error)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   26,
			NumExtensions: 1,
			NumServices:   1,
		},
		GoTypes:           file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_goTypes,
		DependencyIndexes: file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_depIdxs,
		EnumInfos:         file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_enumTypes,
		MessageInfos:      file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_msgTypes,
		ExtensionInfos:    file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_extTypes,
	}.Build()
	File_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto = out.File
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_rawDesc = nil
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_goTypes = nil
	file_github_com_openconfig_gnmi_proto_gnmi_gnmi_proto_depIdxs = nil
}
