# goSDN [![coverage report](https://code.fbi.h-da.de/danet/gosdn/badges/master/coverage.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/master) [![pipeline status](https://code.fbi.h-da.de/danet/gosdn/badges/master/pipeline.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/master)

`goSDN` is a prototypical approach to build a model driven multi-vendor SDN controller.

This repository contains submodules, therefore it must be cloned with
`git clone --recurse-submodules git@code.fbi.h-da.de:danet/gosdn.git`.
If you have cloned the repository without `--recurse-submodules` simply run `git submodule update --init --recursive`
to get all submodules.

# Table of Contents

- [Overview](#overview)
  * [Example](#example)
  * [Structure](#structure)
- [Concepts](#concepts)
- [Installing](#installing)
- [Getting Started](#getting-started)
  * [Playground](#playground)
- [Contributing](CONTRIBUTING.md)
- [License](LICENSE)
- [CI Status](#ci-status)
- [Development Tutorial](#development-tutorial)

# Overview

`goSDN` is also an application that will allow you to manage your multi-vendor
network using one unified controller.

`goSDN` provides:
* Model driven device/network element representation
* Native multi vendor support
* Multi controller environments

## Example
A simple showcase how the controller can be adressed after
`make containerlab-start` is shown below:

![](gosdn-cli-showcase.webm)

## Structure

- The `api` is a representation of the `controllers` Northbound-Interface and
  can be used to communicate with the `controller`.
- The `cli` is the CLI to manage the `controller`.
- `csbi` is the implementation of Containerised-Southbound-Interfaces (based on
  the idea and the proof of concept of Manuel Kieweg). Allowing to request
  capabilities of MNEs and generate a containerised Southbound-Interface based
  on them. They are currently unsupported.
- `controller` represents the `goSDN-controller`.

# Concepts

The `goSDN` controllers core - also called `nucleus` - is a lightweight library
that manages principal network domains and provides southbound interface
operations for managed network elements.

In addition, we provide a simple Northbound-API for the controller ()

## Principal Networking Domain (PND)

The PND is the single source of truth within a network. Its state is held and
maintained by the controller. Any configuration of an MNE has to be applied by
the PND.

## Managed Network Element (MNE)

Any network element directly configured by `goSDN`

# Installing
`goSDN` provides a `Makefile` for all common use cases.

```sh
# build the application files for goSDN, cSBI orchestrator, gosdnc (CLI).
make build

# build the Dockerfiles for goSDN, cSBI orchestrator, gosdnc (CLI).
make containerize-all
```

Now you can start `goSDN` locally by moving to the `artifacts` folder and
running `./gosdn` from the shell.

# Getting Started

If you want to use the the [playground](#playground) you have to make sure you
have [containerlab](https://containerlab.dev/install/) installed on your
system.

## Playground

With the help of [containerlab](https://containerlab.dev/) we provide a simple
test environment to play around with.

The environment contains two [Arista
cEOS](https://www.arista.com/en/products/software-controlled-container-networking),
a goSDN, a cSBI orchestrator and a gNMI target.

> If you're a member of the danet group you should have access to the
> containers repo. Don't forget to `sudo docker login
> registry.code.fbi.h-da.de` (`sudo` is necessary since `containerlab` has to
> be run with it and therefore a normal `docker login` wouldn't be recognized
> by it.)
>
> If you're no member of the danet group you have to [create an
> account](https://www.arista.com/en/login) at Arista and download the Arista
> cEOS image by yourself. Don't forget to change the image name (line `11` in
> the `gosdn.clab.yml` file) to the local one you've downloaded.

```sh
# starts the containerlab topology which contains two Arista cEOS, an cSBI orchestrator, a goSDN controller and gNMI target.
make containerlab-start

# stop the containerlab topology
make containerlab-stop
```

## CLI
Information about how to use the CLI is provided in the `cli` folder, see [here](cli#usage).

# CI Status

| Master | Develop |
| ------ | ------ |
| [![coverage report](https://code.fbi.h-da.de/danet/gosdn/badges/master/coverage.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/master) | [![coverage report](https://code.fbi.h-da.de/danet/gosdn/badges/develop/coverage.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/develop) |
| [![pipeline status](https://code.fbi.h-da.de/danet/gosdn/badges/master/pipeline.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/master) | [![pipeline status](https://code.fbi.h-da.de/danet/gosdn/badges/develop/pipeline.svg)](https://code.fbi.h-da.de/danet/gosdn/-/commits/develop) |

# Development Tutorial

To help with developing there is a small script available, which helps to create the complete dev environment.
For it to work, you need `go`, `docker`, `docker compose` and `containerlab`.

For a quick start simply use `make start-dev-env` to start everything. This can take a while. Afterwards, you see the output of goSDN, to stop it hit Ctrl+C. To stop everything else use `make stop-dev-env`.

If you want more control over your environment, you can use the `manage_virt_env.sh` script directly.

It works like this, if you are in the projects root folder:

`./scripts/manage_virt_env.sh --mode $(start || stop) --topology $PATH_TO_TOPOLOGY --SDNCONFIG $PATH_TO_SDNCONFIG --keepdb (optional)`

`mode` defines if it should start or stop the environment, while the two commands `--topology` and `--sdnconfig` are used to provide the desired files.
The optional flag `keepdb` is used if you want to create the environment without reloading the SDN config file, which is handy if you just want to restart the environment. For every command there is a shortcut available (e.g. -t for --topology, etc.).

Example usages:

`./scripts/manage_virt_env.sh --mode start --topology dev_env_data/clab/basic_two_aristas.yaml --sdnconfig dev_env_data/sdn/basic_two_aristas.json`

`./scripts/manage_virt_env.sh --mode start --topology dev_env_data/clab/basic_two_aristas.yaml --keepdb`

`./scripts/manage_virt_env.sh --mode stop --topology dev_env_data/clab/basic_two_aristas.yaml`

## Backup and restore your mongodb

If you are using the mongodb provided via the `docker-compose.yaml`, you can easily back up and restore your data via two scripts.

```bash
./scripts/backup_mongo_volume.sh $(suffix_of_backup)
```
```bash
./scripts/restore_mongo_volume.sh $(suffix_of_backup)
```

Keep in mind that a restore will restart the mongodb container.
