Introduction
============

This Directory contains various examples for working with the LLVM tools.

All interesting files are from the LLVM project -
See http://llvm.org and in particular http://www.llvm.org/docs/
for more information.

This collection was prepared by Prof. R. C. Moore, fbi.h-da.de
in May 2017 for the Compiler Construction course. No warranty implied or expressed.
See LICENSE.TXT for the original license.

This version has been prepared for LLVM 4.0 (using Arch Linux in a vagrant box)
in May 2017.

This version can be fairly easily adpated to work with LLVM 3.9. 
It does NOT work with earlier versions of LLVM.

All of the example files (fibonacci.cpp, ModuleMaker.cpp and toy*.cpp):

 - are available in the LLVM source tree, for example by running the
   following:
       svn co https://llvm.org/svn/llvm-project/llvm/tags/RELEASE_400/final/
   or by downloading the whole source tarball, where you will find a directory
   named "examples", from:
        http://llvm.org/releases/
   or directly from
        http://releases.llvm.org/10.0.0/llvm-10.0.0.src.tar.xz

 - the directory structure has been simplified, some files have been renamed,
   and a new Makefile is provided which is much simpler than the original cmake
   system (but not guarenteed to work outside Linux).  Test files have also
   been added. See below. 

Still, it should be emphasized that there is nothing really new here -- apart 
from the packaging, everything here is from the LLVM project!

Manifest ("Table of Contents")
===============================

You should have received the following files:

 * `fibonacci.cpp`  
This is a compiler without a front-end, so to speak,
but with an interpreter built in - see ModuleMaker for
an even simpler example.
 * `LICENSE.TXT`         
The LLVM Release Open Source License
(taken verbatim from the University of Illinois/NCSA,
https://github.com/llvm/llvm-project/blob/master/llvm/LICENSE.TXT).
 * `Makefile`  
A Makefile, not supplied by LLVM but written instead
by R. Moore - to make this collection work without the
rest of the LLVM source tree.  You will (of course)
need the LLVM tool set installed (clang, clang++ &
llvm-config and the llvm libs, at the very least).
 * `ModuleMaker.cpp`   
Another example provided in the LLVM source tree.
This file produces binary LLVM bit code for a program
which does nothing but return a status of 5. LLVM
bit code can be run using the LLVM "lli" tool.
Thus, you should be able to do the following:

```
make ModuleMaker  
./ModuleMaker >status5.bc  
lli status5.bc  
echo $? # should print "5"  
```

"Hello World" doesn't get much simpler than this!
(Running "make testModuleMaker" does this, by the way).
 * `README.md`            
This file.
 * `KaleidoscopeJIT.h`   
A header file used by some of the toy4.cpp - toy9.cpp.
This version works with LLVM 10. 
 * `tests`            
A directory containing files in the Kaleidoscope
language, taken from the LLVM Tutorial, see
https://llvm.org/docs/tutorial/MyFirstLanguageFrontend/index.html
Some, but not all, of these are used by "make tests".
 * `toy2.cpp` - `toy9.cpp`          
The source code from the Tutorial, Chapters 2 through 9.

All of the above Chapters are available at
https://llvm.org/docs/tutorial/MyFirstLanguageFrontend/index.html

Building
=========

(1) Install clang and the llvm tool kit.  You can either compile from source
    (see http://www.llvm.org/docs/GettingStarted.html - or perhaps better,
    http://clang.llvm.org/get_started.html) or install binaries that you find
    elsewhere (you SHOULD get LLVM 10.0.0 - No guarantees are made for older
    OR NEWER versions!).

(2) Run `make` (or perhaps `make clean` and then `make`).

(3) If you wish, run `make tests` to run (almost) all the programs delivered
    in this colleciton.  The output from `make tests` is very long.
    Each program can also be tested individually, for example with
    `make testFibonacci` or `make testModuleMaker` or `make test5` 
    (read the Makefile to see all alternatives).  
    **Note**: `make test9` is broken. We know.  
    That's why it's not included in `make tests`.   
    Please feel free to fix it. 

Further Reading
===============

These files are only provided to illustrate how LLVM can be used.  The code from
the tutorial should be read together with the tutorial.

More information is available:

 * Overview of the LLVM Documentation:
http://llvm.org/releases/10.0.0/docs/index.html
 * The LLVM ("Kaledeiscope") Tutorial:
https://llvm.org/docs/tutorial/MyFirstLanguageFrontend/index.html
 * Guide for Programmers:
http://llvm.org/releases/10.0.0/docs/ProgrammersManual.html
 * Guide to the LLVM IR (LLVM Intermediate Representation):
http://llvm.org/releases/10.0.0/docs/LangRef.html







